(function () {
    'use strict';

    angular.module('portoAlto.controllers').controller('ReservaCtrl', ReservaCtrl);

    ReservaCtrl.$inject = ['$scope', '$http'];

    function ReservaCtrl($scope, $http) {
        console.log('<<<<carga ReservaCtrl>>>>');

        //$scope.urlBase = 'http://portoalto.com.co/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/servicios/v1/';
//        $scope.urlBase = 'http://localhost:8050/newPortoAlto/servicios/v1/';
        $scope.urlApi = 'https://chart.googleapis.com/chart?chs=250x250&cht=qr&chl=';
        $scope.selectHora = [];
        $scope.selectPersona = [];
        $scope.showFormLogin = true;
        $scope.showFormRegistro = false;
        $scope.showFormReserva = false;
        $scope.showFormMisReservar = false;
        $scope.conReserva = false;
        $scope.datosFormulario = {};
        $scope.errores = {};
        $scope.regExpEmail = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.([a-zA-Z]{2,4})+$/;
        $scope.regExpNumero = /^[0-9]*$/;
        $scope.mensajeError;
        $scope.resultadoSesion;
        $scope.disable = true;
        $scope.url;
        $scope.total;
        $scope.showBotonPagar = false;
        $scope.totalDecoracion = 0;

        $scope.getDecoracion = getDecoracion;
        $scope.iniciarSesion = iniciarSesion;
        $scope.validaCampoApellido = validaCampoApellido;
        $scope.validaCampoDocumento = validaCampoDocumento;
        $scope.aceptar = aceptar;
        $scope.formRegistro = formRegistro;
        $scope.cancelar = cancelar;
        $scope.regresar = regresar;
        $scope.registrarse = registrarse;
        $scope.validaCampoNombre = validaCampoNombre;
        $scope.validaCampoTelefono = validaCampoTelefono;
        $scope.validaCampoEmail = validaCampoEmail;
        $scope.validaCampoGenero = validaCampoGenero;
        $scope.infoUsuario = infoUsuario;
        $scope.reserva = reserva;
        $scope.validaCampoHora = validaCampoHora;
        $scope.validaCampoMotivo = validaCampoMotivo;
        $scope.validaCampoFecha = validaCampoFecha;
        $scope.validaCampoNroPersonas = validaCampoNroPersonas;
        //$scope.validaCampoDecoracion = validaCampoDecoracion;
        $scope.misReservas = misReservas;
        $scope.showReserva = showReserva;
        $scope.confirmarReserva = confirmarReserva;
        $scope.generateQr = generateQr;
        $scope.sentMail = sentMail;
        $scope.getParametros = getParametros;
        $scope.getValor = getValor;
        $scope.actualizaReserva = actualizaReserva;
        
        actualizaReserva();
        
        function actualizaReserva(){
            $http.get($scope.urlBase + 'actualizaReservas')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            console.log("Se actualizaron las reservas");
                        }else{
                             console.log("No se actualizaron las reservas");
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }
        
        
        function getValor() {
            $scope.datosPay = {};
            $scope.datosPay.nodocumento = $scope.resultadoUsuario.nodocumento;
            $http.post($scope.urlBase + 'getValor', $scope.datosPay)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            for (var i = 0; data.object.length > i; i++) {
                                if(data.object[i].valor !== null){
                                    $scope.totalDecoracion = data.object[i].valor;
                                }else{
                                    $scope.totalDecoracion = 0;
                                }
                            }
                            getParametros();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function getParametros() {
            $scope.datosPay = {};
            var numeroPersona;
            var codReserva;
            $scope.datosPay.nodocumento = $scope.resultadoUsuario.nodocumento;
            for (var i = 0; $scope.resultadoReserva.length > i; i++) {
                numeroPersona = $scope.resultadoReserva[i].num_personas;
                codReserva = $scope.resultadoReserva[i].id_reserva;
            }
            $scope.datosPay.numPersonas = numeroPersona;
            $scope.datosPay.codReserva = codReserva;
            $scope.datosPay.total = $scope.totalDecoracion;
            $http.post($scope.urlBase + 'getParametros', $scope.datosPay)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.parametros = data.object;
                            //console.log(JSON.stringify($scope.parametros));
                            for (var i = 0; $scope.parametros.length > i; i++) {
                                $scope.merchantId = $scope.parametros[i].merchantId;
                                $scope.referenceCode = $scope.parametros[i].referenceCode;
                                $scope.amount = $scope.parametros[i].total;
                                $scope.signature = $scope.parametros[i].signature;
                                $scope.accountId = $scope.parametros[i].accountId;
                                $scope.currency = $scope.parametros[i].currency;
                                $scope.responseUrl = "http://www.portoalto.com.co/reservas/index.php?confirme=" + $scope.parametros[i].accountId;
                                $scope.confirmationUrl = "http://www.portoalto.com.co/reservas/index.php?confirme=" + $scope.parametros[i].accountId;
                                $scope.nombre = $scope.resultadoUsuario.nombres;
                                $scope.apellidos = $scope.resultadoUsuario.apellidos;
                            }
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }



        function sentMail() {
            $scope.datosMail = {};
            $scope.datosMail.nombre = $scope.datosFormulario.nombres + " " + $scope.datosFormulario.apellido;
            $scope.datosMail.email = $scope.datosFormulario.email;
            $scope.datosMail.mensaje = "Registro exitoso!!! Bienvenido señor@ " 
                    + $scope.datosFormulario.nombres + 
                    ", presiona el siguiente link para ver tu codigo QR : " + $scope.urlApi + $scope.datosFormulario.documento;
            $http.post($scope.urlBase + 'sentMail', $scope.datosMail)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.datosFormulario = {};
                            $scope.datos = {};
                            $scope.showFormLogin = true;
                            $scope.showFormRegistro = false;
                            $scope.showFormReserva = false;
                            $scope.showFormMisReservar = false;
                            $scope.conReserva = false;
                            $('#dlgConfContizacion').modal('hide');
                            $('#dlgSucces').modal({backdrop: 'static', keyboard: false});
                        } else {
                            $('#dlgError').modal({backdrop: 'static', keyboard: false});
                            $scope.message = data.message;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function confirmarReserva() {
            $scope.datos = {};
            $scope.datos.telefono = $scope.datosFormulario.telefono;
            $scope.datos.hora = $scope.datosFormulario.hora;
            $scope.datos.motivo = $scope.datosFormulario.motivo;
            $scope.datos.fecha = $scope.datosFormulario.fecha;
            $scope.datos.nroPersonas = $scope.datosFormulario.personas.id;
            if($scope.datosFormulario.decoracion){
                $scope.datos.decoracion = $scope.datosFormulario.decoracion.id_decoracion;
            }else{
                $scope.datos.decoracion = 0;
            }
            $scope.datos.email = $scope.resultadoUsuario.email;
            $scope.datos.idPersona = $scope.resultadoSesion.idPersona;
            $http.post($scope.urlBase + 'registrarReserva', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $('#dlgSuccess').modal();
                            $scope.mensajeExito = 'Se registró la reserva de forma exitosa.';
                            aceptar();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function showReserva() {
            getDecoracion();
            $scope.showFormReserva = true;
            $scope.showFormMisReservar = false;
        }
        
        $scope.aceptaTermino = aceptaTermino;
        
        function aceptaTermino(){
            $scope.checkboxModel = {
                value1 : true,
                value2 : 'YES'
            };
        }

        function reserva() {
            var error = false;
            if (!$scope.datosFormulario.telefono) {
                $scope.errores.telefono = 'El campo es obligatorio.';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.telefono)) {
                    $scope.errores.telefono = 'El campo debe ser númerico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.hora) {
                $scope.errores.hora = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.motivo) {
                $scope.errores.motivo = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.fecha) {
                $scope.errores.fecha = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.personas) {
                $scope.errores.nroPersonas = 'El campo es obligatorio.';
                error = true;
            }
            //if (!$scope.datosFormulario.decoracion) {
               // $scope.errores.decoracion = 'El campo es obligatorio.';
              //  error = true;
            //}
//            if (!$scope.datosFormulario.email) {
//                $scope.errores.email = 'Campo obligatorio';
//                error = true;
//            } else {
//                if (!$scope.regExpEmail.test($scope.datosFormulario.email)) {
//                    $scope.errores.email = 'El email ingresado no cumple con el formato adecuado.';
//                }
//            }
            if(!$scope.checkboxModel.value1){
                $scope.errores.aceptoConsumo = 'El campo es obligatorio.';
                error = true;
            }
            if (!error) {
                $('#dlgReserva').modal({backdrop: 'static', keyboard: false});
            }
        }

        //function validaCampoDecoracion() {
            //if ($scope.datosFormulario.decoracion) {
            //    $scope.errores.decoracion = '';
          //  }
        //}

        function validaCampoNroPersonas() {
            if ($scope.datosFormulario.personas) {
                $scope.errores.nroPersonas = '';
            }
        }

        function validaCampoFecha() {
            if ($scope.datosFormulario.fecha) {
                $scope.errores.fecha = '';
            }
        }

        function validaCampoMotivo() {
            if ($scope.datosFormulario.motivo) {
                $scope.errores.motivo = '';
            }
        }

        function validaCampoHora() {
            if ($scope.datosFormulario.hora) {
                $scope.errores.hora = '';
            }
        }

        function infoUsuario() {
            $scope.datos = {};
            $scope.datos.cedula = $scope.datosFormulario.documento;
            $http.post($scope.urlBase + 'infoUser', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultadoUsuario = data.object;
                            misReservas();
                            $scope.showFormLogin = false;
                            $scope.showFormRegistro = false;
                            $scope.showFormReserva = false;
                            $scope.showFormMisReservar = true;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function registrarse() {
            var error = false;
            if (!$scope.datosFormulario.nombres) {
                $scope.errores.nombres = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.apellido) {
                $scope.errores.apellido = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.documento) {
                $scope.errores.documento = 'El campo es obligatorio.';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.documento)) {
                    $scope.errores.documento = 'El campo debe ser númerico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.telefono) {
                $scope.errores.telefono = 'El campo es obligatorio.';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.telefono)) {
                    $scope.errores.telefono = 'El campo debe ser númerico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.email) {
                $scope.errores.email = 'Campo obligatorio';
                error = true;
            } else {
                if (!$scope.regExpEmail.test($scope.datosFormulario.email)) {
                    $scope.errores.email = 'El email ingresado no cumple con el formato adecuado.';
                }
            }
            if (!$scope.datosFormulario.genero) {
                $scope.errores.genero = 'El campo es obligatorio.';
                error = true;
            }
            if (!error) {
                $scope.datos = {};
                $scope.datos.nombres = $scope.datosFormulario.nombres;
                $scope.datos.apellidos = $scope.datosFormulario.apellido;
                $scope.datos.documento = $scope.datosFormulario.documento;
                $scope.datos.telefono = $scope.datosFormulario.telefono;
                $scope.datos.email = $scope.datosFormulario.email;
                $scope.datos.genero = $scope.datosFormulario.genero;
                $http.post($scope.urlBase + 'registrarUsuario', $scope.datos)
                        .success(function (data, status, header, config) {
                            if (data.status === 'SUCCESS') {
                                $('#dlgSuccess').modal();
                                $scope.mensajeExito = 'Te acabas de registrar de forma exitosa.';
                                $scope.url = $scope.urlApi + $scope.datosFormulario.documento;
//                                iniciarSesion();
//                                misReservas();
                                sentMail();
//                                generateQr($scope.url);
                            } else {
                                $('#dlgError').modal();
                                $scope.mensajeError = data.message;
                            }
                        }).error(function (data, status, header, config) {
                    alert('Error al consultar la información');
                });
            }
        }

        function generateQr(item) {
            $scope.datosQr = {};
            $scope.datosQr.urlPicture = item;
            $http.post($scope.urlBase + 'createQr', $scope.datosQr)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            alert(data.object);
                        } else {
                            $('#dlgError').modal();
                            $scope.mensajeError = data.message;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function cancelar() {
            $scope.datosFormulario = {};
            $scope.errores = {};
            $scope.showFormLogin = true;
            $scope.showFormReserva = false;
            $scope.showFormRegistro = false;
            $scope.showFormMisReservar = false;
        }
        
        function regresar() {
            $scope.datosFormulario = {};
            $scope.errores = {};
            $scope.showFormLogin = false;
            $scope.showFormReserva = false;
            $scope.showFormRegistro = false;
            $scope.showFormMisReservar = true;
        }

        function formRegistro() {
            $scope.datosFormulario = {};
            $scope.errores = {};
            $scope.showFormLogin = false;
            $scope.showFormReserva = false;
            $scope.showFormRegistro = true;
        }
        

        function iniciarSesion() {
            var error = false;
            if (!$scope.datosFormulario.apellido) {
                $scope.errores.apellido = 'Campo obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.documento) {
                $scope.errores.documento = 'Campo obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.documento)) {
                    $scope.errores.documento = 'El campo debe ser númerico';
                    error = true;
                }
            }
            if (!error) {
                $scope.datos = {};
                $scope.datos.cedula = $scope.datosFormulario.documento;
                $scope.datos.apell = $scope.datosFormulario.apellido;
                $http.post($scope.urlBase + 'iniciarSesion', $scope.datos)
                        .success(function (data, status, header, config) {
                            if (data.status === 'SUCCESS') {
                                $('#dlgSuccess').modal();
                                $scope.mensajeExito = 'Bienvenido.';
                                $scope.resultadoSesion = data.object;
                                infoUsuario();
//                                $scope.url = $scope.urlApi + $scope.datosFormulario.documento;
//                                generateQr($scope.url);
                            } else {
                                $('#dlgError').modal();
                                $scope.mensajeError = 'Ups, no te encuentras registrado.';
                            }
                        }).error(function (data, status, header, config) {
                    alert('Error al consultar la información');
                });
            }
        }

        function misReservas() {
            $('#dlgReserva').modal('hide');
            $scope.datos.idPersona = $scope.resultadoSesion.idPersona;
            $http.post($scope.urlBase + 'misReservas', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultadoReserva = data.object;
                            $scope.conReserva = true;
                            getValor();
                            for (var i = 0; data.object.length > i; i++) {
                                if (data.object[i].estado === 'Sin Pagar') {
                                    $scope.showBotonPagar = true;
                                    $scope.disable = false;
                                }
                            }
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function aceptar() {
            $('#dlgSuccess').modal('hide');
            infoUsuario();
            misReservas();
            $scope.datosFormulario = {};
            $scope.errores = {};
            $scope.showFormMisReservar = true;
            $scope.showFormReserva = false;
            $scope.showFormLogin = false;
            $scope.showFormRegistro = false;
        }

        function validaCampoDocumento() {
            if ($scope.datosFormulario.documento) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.documento)) {
                    $scope.errores.documento = 'El campo debe ser númerico';
                } else {
                    $scope.errores.documento = '';
                }
            }
        }

        function validaCampoGenero() {
            if ($scope.datosFormulario.genero) {
                $scope.errores.genero = '';
            }
        }

        function validaCampoEmail() {
            if ($scope.datosFormulario.email) {
                if ($scope.regExpEmail.test($scope.datosFormulario.email)) {
                    $scope.errores.email = '';
                } else {
                    $scope.errores.email = 'El email ingresado no cumple con el formato adecuado.';
                }
            }
        }

        function validaCampoTelefono() {
            if ($scope.datosFormulario.telefono) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.telefono)) {
                    $scope.errores.telefono = 'El campo debe ser númerico';
                } else {
                    $scope.errores.telefono = '';
                }
            }
        }

        function validaCampoNombre() {
            if ($scope.datosFormulario.nombres) {
                $scope.errores.nombres = '';
            }
        }

        function validaCampoApellido() {
            if ($scope.datosFormulario.apellido) {
                $scope.errores.apellido = '';
            }
        }

        function getDecoracion() {
            $http.get($scope.urlBase + 'getDecoraciones')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.decoracion = data.object;
                            //console.log(JSON.stringify($scope.decoracion));
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }
        
        getDecoracion();

//        $scope.hora1 = {id: 1, hora: '00:00:00', descripcion: '00:00:00 AM'};
//        $scope.hora2 = {id: 2, hora: '1:00:00', descripcion: '1:00:00 AM'};
//        $scope.hora3 = {id: 3, hora: '2:00:00', descripcion: '2:00:00 AM'};
//        $scope.hora4 = {id: 4, hora: '3:00:00', descripcion: '3:00:00 AM'};
//        $scope.hora5 = {id: 5, hora: '4:00:00', descripcion: '4:00:00 AM'};
//        $scope.hora6 = {id: 6, hora: '5:00:00', descripcion: '5:00:00 AM'};
//        $scope.hora7 = {id: 7, hora: '6:00:00', descripcion: '6:00:00 AM'};
//        $scope.hora8 = {id: 8, hora: '7:00:00', descripcion: '7:00:00 AM'};
//        $scope.hora9 = {id: 9, hora: '8:00:00', descripcion: '8:00:00 AM'};
//        $scope.hora10 = {id: 10, hora: '9:00:00', descripcion: '9:00:00 AM'};
//        $scope.hora11 = {id: 11, hora: '10:00:00', descripcion: '10:00:00 AM'};
//        $scope.hora12 = {id: 12, hora: '11:00:00', descripcion: '11:00:00 AM'};
        $scope.hora13 = {id: 13, hora: '12:00:00', descripcion: '12:00:00 MD'};
        $scope.hora14 = {id: 14, hora: '13:00:00', descripcion: '13:00:00 PM'};
        $scope.hora15 = {id: 15, hora: '14:00:00', descripcion: '14:00:00 PM'};
        $scope.hora16 = {id: 16, hora: '15:00:00', descripcion: '15:00:00 PM'};
        $scope.hora17 = {id: 17, hora: '16:00:00', descripcion: '16:00:00 PM'};
        $scope.hora18 = {id: 18, hora: '17:00:00', descripcion: '17:00:00 PM'};
        $scope.hora19 = {id: 19, hora: '18:00:00', descripcion: '18:00:00 PM'};
        $scope.hora20 = {id: 20, hora: '19:00:00', descripcion: '19:00:00 PM'};
        $scope.hora21 = {id: 21, hora: '20:00:00', descripcion: '20:00:00 PM'};
        $scope.hora22 = {id: 22, hora: '21:00:00', descripcion: '21:00:00 PM'};
//        $scope.hora23 = {id: 23, hora: '22:00:00', descripcion: '22:00:00 PM'};
//        $scope.hora24 = {id: 24, hora: '23:00:00', descripcion: '23:00:00 PM'};


//        $scope.selectHora.push($scope.hora1);
//        $scope.selectHora.push($scope.hora2);
//        $scope.selectHora.push($scope.hora3);
//        $scope.selectHora.push($scope.hora4);
//        $scope.selectHora.push($scope.hora5);
//        $scope.selectHora.push($scope.hora6);
//        $scope.selectHora.push($scope.hora7);
//        $scope.selectHora.push($scope.hora8);
//        $scope.selectHora.push($scope.hora9);
//        $scope.selectHora.push($scope.hora10);
//        $scope.selectHora.push($scope.hora11);
//        $scope.selectHora.push($scope.hora12);
        $scope.selectHora.push($scope.hora13);
        $scope.selectHora.push($scope.hora14);
        $scope.selectHora.push($scope.hora15);
        $scope.selectHora.push($scope.hora16);
        $scope.selectHora.push($scope.hora17);
        $scope.selectHora.push($scope.hora18);
        $scope.selectHora.push($scope.hora19);
        $scope.selectHora.push($scope.hora20);
        $scope.selectHora.push($scope.hora21);
        $scope.selectHora.push($scope.hora22);
//        $scope.selectHora.push($scope.hora23);
//        $scope.selectHora.push($scope.hora24);

        $scope.persona1 = {id: 1, descripcion: '1 Persona'};
        $scope.persona2 = {id: 2, descripcion: '2 Personas'};
        $scope.persona3 = {id: 3, descripcion: '3 Personas'};
        $scope.persona4 = {id: 4, descripcion: '4 Personas'};
        $scope.persona5 = {id: 5, descripcion: '5 Personas'};
        $scope.persona6 = {id: 6, descripcion: '6 Personas'};
        $scope.persona7 = {id: 7, descripcion: '7 Personas'};
        $scope.persona8 = {id: 8, descripcion: '8 Personas'};
        $scope.persona9 = {id: 9, descripcion: '9 Personas'};
        $scope.persona10 = {id: 10, descripcion: '10 Personas'};
        $scope.persona11 = {id: 11, descripcion: '11 Personas'};
        $scope.persona12 = {id: 12, descripcion: '12 Personas'};
        $scope.persona13 = {id: 13, descripcion: '13 Personas'};
        $scope.persona14 = {id: 14, descripcion: '14 Personas'};
        $scope.persona15 = {id: 15, descripcion: '15 Personas'};
        $scope.persona16 = {id: 16, descripcion: '16 Personas'};
        $scope.persona17 = {id: 17, descripcion: '17 Personas'};
        $scope.persona18 = {id: 18, descripcion: '18 Personas'};
        $scope.persona19 = {id: 19, descripcion: '19 Personas'};
        $scope.persona20 = {id: 20, descripcion: '20 Personas ó más'};


        $scope.selectPersona.push($scope.persona1);
        $scope.selectPersona.push($scope.persona2);
        $scope.selectPersona.push($scope.persona3);
        $scope.selectPersona.push($scope.persona4);
        $scope.selectPersona.push($scope.persona5);
        $scope.selectPersona.push($scope.persona6);
        $scope.selectPersona.push($scope.persona7);
        $scope.selectPersona.push($scope.persona8);
        $scope.selectPersona.push($scope.persona9);
        $scope.selectPersona.push($scope.persona10);
        $scope.selectPersona.push($scope.persona11);
        $scope.selectPersona.push($scope.persona12);
        $scope.selectPersona.push($scope.persona13);
        $scope.selectPersona.push($scope.persona14);
        $scope.selectPersona.push($scope.persona15);
        $scope.selectPersona.push($scope.persona16);
        $scope.selectPersona.push($scope.persona17);
        $scope.selectPersona.push($scope.persona18);
        $scope.selectPersona.push($scope.persona19);
        $scope.selectPersona.push($scope.persona20);

    }
})(); 