(function () {
    'use strict';

    angular.module('portoAlto.controllers').controller('EventoCtrl', EventoCtrl);

    EventoCtrl.$inject = ['$scope', '$http'];

    function EventoCtrl($scope, $http) {
        console.log('<<<<controler EventoCtrl>>>');

//        $scope.urlBase = 'http://localhost:8050/newPortoAlto/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/servicios/v1/';
        $scope.showEventos = false;
        $scope.showSinEventos = false;
        $scope.pageSize = 3;
        $scope.currentPage = 1;

        $scope.getEvento = getEvento;

        function getEvento() {
            $('#dlgEspera').modal({backdrop: 'static', keyboard: false});
            $http.get($scope.urlBase + 'eventos')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultado = data.object;
                            $scope.showEventos = true;
                        }else{
                            $scope.showSinEventos = true;
                        }
                        $('#dlgEspera').modal('hide');
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        getEvento();
    }
})(); 