(function () {
    'use strict';

    angular.module('portoAlto.controllers').controller('ContactoCtrl', ContactoCtrl);

    ContactoCtrl.$inject = ['$scope', '$http'];

    function ContactoCtrl($scope, $http) {
        console.log('<<<<load ContactoCtrl>>>>');

        $scope.datosFormulario = {};
        $scope.errores = {};
        $scope.regExp = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.([a-zA-Z]{2,4})+$/;
//        $scope.urlBase = 'http://localhost:8050/newPortoAlto/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/servicios/v1/';

        $scope.enviar = enviar;
        $scope.validaCampoMensaje = validaCampoMensaje;
        $scope.validaCampoAsunto = validaCampoAsunto;
        $scope.validaCampoEmail = validaCampoEmail;
        $scope.validaCampoNombre = validaCampoNombre;

        function validaCampoAsunto() {
            if ($scope.datosFormulario.asunto) {
                $scope.errores.asunto = '';
            }
        }

        function validaCampoEmail() {
            if ($scope.datosFormulario.email) {
                if ($scope.regExp.test($scope.datosFormulario.email)) {
                    $scope.errores.email = '';
                } else {
                    $scope.errores.email = 'El email ingresado no cumple con el formato adecuado.';
                }
            }
        }

        function validaCampoNombre() {
            if ($scope.datosFormulario.nombre) {
                $scope.errores.nombre = '';
            }
        }

        function validaCampoMensaje() {
            if ($scope.datosFormulario.mensaje) {
                $scope.errores.mensaje = '';
            }
        }

        function enviar() {
            var error = false;
            if (!$scope.datosFormulario.nombre) {
                $scope.errores.nombre = 'Campo obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.email) {
                $scope.errores.email = 'Campo obligatorio';
                error = true;
            } else {
                if (!$scope.regExp.test($scope.datosFormulario.email)) {
                    $scope.errores.email = 'El email ingresado no cumple con el formato adecuado.';
                }
            }
            if (!$scope.datosFormulario.asunto) {
                $scope.errores.asunto = 'Campo obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.mensaje) {
                $scope.errores.mensaje = 'Campo obligatorio';
                error = true;
            }
            if (!error) {
                $scope.datos = {};
                $scope.datos.nombre = $scope.datosFormulario.nombre;
                $scope.datos.email = $scope.datosFormulario.email;
                $scope.datos.asunto = $scope.datosFormulario.asunto;
                $scope.datos.mensaje = $scope.datosFormulario.mensaje;
                $http.post($scope.urlBase + 'contacto', $scope.datos)
                        .success(function (data, status, header, config) {
                            if (data.status === 'SUCCESS') {
                                $scope.datosFormulario = {};
                                $('#dlgSuccess').modal();
                            }
                        }).error(function (data, status, header, config) {
                    alert('Error al consultar la información');
                });
            }
        }

    }
})(); 