<?php

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header('Access-Control-Allow-Methods: GET, POST');
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
//******************************************************************************
//Servicio para iniciar sesion
$app->post('/iniciarSesion', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $cedula = $r->cedula;
        $apell = $r->apell;

        $query = "SELECT * FROM persona WHERE nodocumento='" . $cedula . "' AND apellidos LIKE '" . $apell . "%'";

        $respuesta = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($respuesta as $row) {
                $objeto = Array();
                $objeto['idPersona'] = $row["id_persona"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno[0];
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar un usuario
$app->post('/registrarUsuario', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombres = $r->nombres;
        $apellidos = $r->apellidos;
        $documento = $r->documento;
        $telefono = $r->telefono;
        $email = $r->email;
        $genero = $r->genero;

        $queryValidaRegistro = "SELECT * FROM persona WHERE nodocumento='" . $documento . "'";
        $respuestaValidaRegistro = $con->query($queryValidaRegistro);

        if ($con->num_rows() > 0) {
            $response["status"] = "ERROR";
            $response['message'] = "El No. de documento ya existe";
        } else {
            $queryValidaEmail = "SELECT * FROM persona WHERE email='" . $email . "'";
            $respuestaValidaEmail = $con->query($queryValidaEmail);
            if ($con->num_rows() > 0) {
                $response["status"] = "ERROR";
                $response['message'] = "El email ya existe";
            } else {
                $queryInsert = "INSERT INTO persona VALUES (NULL, UPPER('" . $nombres . "'), UPPER('" . $apellidos . "'), '" . $documento . "', '" . $telefono . "', UPPER('" . $email . "'), '" . $genero . "')";

                $respuestaInsert = $con->query($queryInsert);
                $response["status"] = "SUCCESS";
                $response["message"] = "Registro exitoso";
            }
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener las promociones
$app->get('/promociones', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM promociones WHERE vigente_promo='1' ORDER BY nom_promo ASC";

        $listPromociones = $con->query($query);


        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($listPromociones as $row) {
                $objeto = Array();
                $objeto['dato1'] = $row["id_promo"];
                $objeto['dato2'] = $row["nom_promo"];
                $objeto['dato3'] = $row["desc_promo"];
                $objeto['dato4'] = $row["valor_promo"];
                $dir = 'http://www.portoalto.com.co/Administrativo/Administrativo/' . $row["img_promo"];
                $objeto['dato5'] = $dir;
                $objeto['dato6'] = $row["vigente_promo"];
                $objeto['base64_imagen'] = $row["base64_imagen"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener las mesas
$app->get('/mesas', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM mesas WHERE vigente='1' ORDER BY id_mesa";

        $listMesas = $con->query($query);


        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($listMesas as $row) {
                $objeto = Array();
                $objeto['dato1'] = $row["id_mesa"];
                $objeto['dato2'] = $row["desc_corta_mesa"];
                $objeto['dato3'] = $row["descripcion_mesa"];
                $dir = 'http://www.portoalto.com.co/Administrativo/Administrativo/' . $row["imagen"];
                $objeto['dato4'] = $dir;
                $objeto['dato5'] = $row["vigente"];
                $objeto['dato6'] = $row["estado"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener los eventos disponibles
$app->get('/eventos', function() {
    $response = array();
    try {
        $con = new conectar();

        $queryEventosPasados = "SELECT * FROM eventos WHERE fecha_evento <= '" . date("Y-m-d H:i:s") . "' ORDER BY fecha_evento DESC";

        $listEventoPasados = $con->query($queryEventosPasados);

        //Elimina los eventos anteriores a la fecha actual
        /*
        foreach ($listEventoPasados as $row) {
            //unlink("./Administrativo/" . $row["imagen_evento"]);
            $con->query("UPDATE eventos SET evento_estado = 0 WHERE id_evento='" . $row["id_evento"] . "';");
        }*/

        /*
        $queryEventosFuturos = "SELECT * FROM eventos WHERE evento_estado = 1 ORDER BY fecha_evento DESC";*/
        
        $queryEventosFuturos = "SELECT * FROM eventos WHERE evento_estado = 1 ORDER BY fecha_evento DESC";

        $listEventoFuturos = $con->query($queryEventosFuturos);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($listEventoFuturos as $row) {
                $objeto = Array();
                $objeto['dato1'] = $row["id_evento"];
                $objeto['dato2'] = $row["nombre_evento"];
                $objeto['dato3'] = $row["desc_evento"];
                $objeto['dato4'] = $row["imagen_evento"];
                $objeto['dato5'] = $row["fecha_evento"];
                $objeto['base64_imagen'] = $row["base64_imagen"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener las mesas disponibles
$app->get('/mesasDisponibles', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM mesas m WHERE NOT EXISTS (SELECT 1 FROM reserva r WHERE r.id_mesa = m.id_mesa)";

        $listMesas = $con->query($query);


        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($listMesas as $row) {
                $objeto = Array();
                $objeto['dato1'] = $row["id_mesa"];
                $objeto['dato2'] = $row["desc_corta_mesa"];
                $objeto['dato3'] = $row["descripcion_mesa"];
                $dir = 'http://www.portoalto.com.co/Administrativo/Administrativo/' . $row["imagen"];
                $objeto['dato4'] = $dir;
                $objeto['dato5'] = $row["vigente"];
                $objeto['dato6'] = $row["estado"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para iniciar sesion para vigilancia
$app->post('/iniciarSesionVigilancia', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $usuario = $r->usuario;
        $pass = $r->pass;

        $query = "SELECT * FROM usuarios WHERE usuario='" . $usuario . "' AND clave='" . md5($pass) . "' AND estado='1' AND rol='0'";

        $respuesta = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($respuesta as $row) {
                $objeto = Array();
                $objeto['idUsuario'] = $row["id_usuario"];
                $objeto['email'] = $row["email"];
                $objeto['usuario'] = $row["usuario"];
                $objeto['nombre'] = $row["nombre"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno[0];
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para consultar la información por filtro de busqueda
$app->post('/busquedaContenido', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $buscador = $r->buscador;

        $query = "SELECT * FROM contenido WHERE nombre_contenido LIKE '%" . $buscador . "%' OR id_cat_cont=(SELECT id_categoria FROM categoria_contenido WHERE nombre_categoria LIKE '%" . $buscador . "%' LIMIT 0, 1) ORDER BY nombre_contenido LIMIT 0, 5";

        $respuesta = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($respuesta as $row) {
                $objeto = Array();
                $objeto['idContenido'] = $row["id_contenido"];
                $objeto['fechaCreacion'] = $row["fecha_creacion"];
                $objeto['nombreContenido'] = $row["nombre_contenido"];
                $objeto['decCorta'] = $row["desc_corta_contenido"];
                $objeto['descripcion'] = $row["desc_contenido"];
                $dir = 'http://www.portoalto.com.co/Administrativo/Administrativo/' . $row["imagen"];
                $objeto['imagen'] = $dir;
                $objeto['valor'] = $row["valor_unitario"];
                $objeto['vigencia'] = $row["vigencia"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno[0];
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para consultar la información del contenido sin filtrar
$app->get('/listarContenido', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM reserva INNER JOIN reserva_contenido ON reserva_contenido.id_reserva = reserva.id_reserva AND reserva.estado != 'Abierta' GROUP BY id_contenido LIMIT 0, 3";

        $list = $con->query($query);


        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['dato1'] = $row["id_reserva"];
                $objeto['dato2'] = $row["id_persona_reserva"];
                $objeto['dato3'] = $row["estado"];
                $objeto['dato4'] = $row["fecha_creacion"];
                $objeto['dato5'] = $row["fecha_reserva"];
                $objeto['dato6'] = $row["id_mesa"];
                $objeto['dato7'] = $row["Origen"];
                $objeto['dato8'] = $row["num_personas"];
                $objeto['dato9'] = $row["motivo"];
                $objeto['dato10'] = $row["id_res_cont"];
                $objeto['dato11'] = $row["id_reserva"];
                $objeto['dato12'] = $row["id_contenido"];
                $objeto['dato13'] = $row["valor"];
                $objeto['dato14'] = $row["cantidad"];


                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para guardar la calificación 
$app->post('/registrarCalificacion', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $idPersona = $r->idPersona;
        $calificacion = $r->calificacion;
        $satisfaccion = $r->satisfaccion;
        $observacion = $r->observacion;

        $query = "INSERT INTO calificacion VALUES (NULL, '" . $idPersona . "', '" . $calificacion . "', '" . $satisfaccion . "', '" . date("Y-m-d H:i:s") . "', '" . $observacion . "')";

        $respuesta = $con->query($query);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para cancelar una reserva
$app->post('/cancelarReserva', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $idReserva = $r->idReserva;

        /* $response["status"] = "ok";
          $response["message"] = "test";
          $response["object"] =  $cedula; */


        $query = "SELECT * FROM reserva WHERE id_reserva='" . $idReserva . "'";
        $respuesta = $con->query($query);
        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {

            $queryUpdate = "UPDATE reserva SET estado = 'Cancelada' WHERE id_reserva='" . $idReserva . "'";

            $respuestaUpdate = $con->query($queryUpdate);
            $response["status"] = "SUCCESS";
            $response["message"] = "La reserva ha sido cancelada exitosamente";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener la info del user y armar el pasoporto
//Carlos
$app->post('/infoUser', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $cedula = $r->cedula;

        /* $response["status"] = "ok";
          $response["message"] = "test";
          $response["object"] =  $cedula; */


        $query = "SELECT * FROM persona WHERE nodocumento='" . $cedula . "'";
        $respuesta = $con->query($query);
        if (!$respuesta) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {

            $listaRetorno = Array();
            $count = 0;
            foreach ($respuesta as $row) {
                $objeto = Array();
                $objeto['nombres'] = $row["nombres"];
                $objeto['apellidos'] = $row["apellidos"];
                $objeto['nodocumento'] = $row["nodocumento"];
                $objeto['email'] = $row["email"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }

            $response["object"] = $listaRetorno[0];
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para consultar cualquier cosa
//David
$app->post('/buscador', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $parametro = $r->parametro;

        $query = "SELECT e.nombre_evento AS EVENTO, e.desc_evento AS DESCRIPCION, e.imagen_evento AS IMAGEN FROM eventos e WHERE e.desc_evento LIKE '%" . $parametro . "%'
        UNION ALL
        SELECT p.nom_promo AS EVENTO, p.desc_promo AS DESCRIPCION, p.img_promo AS IMAGEN FROM promociones p WHERE p.desc_promo LIKE '%" . $parametro . "%'
        UNION ALL
        SELECT c.nombre_contenido AS EVENTO, c.desc_contenido AS DESCRIPCION, c.imagen AS IMAGEN FROM contenido c WHERE c.desc_contenido LIKE '%" . $parametro . "%'";

        $respuesta = $con->query($query);
        if (!$respuesta) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {

            $listaRetorno = Array();
            $count = 0;
            foreach ($respuesta as $row) {
                $objeto = Array();
                $objeto['evento'] = $row["EVENTO"];
                $objeto['descripcion'] = $row["DESCRIPCION"];
                $objeto['imagen'] = $row["IMAGEN"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }

            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar el formulario de contacto
//David
$app->post('/contacto', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $email = $r->email;
        $asunto = $r->asunto;
        $mensaje = $r->mensaje;

        $query = "INSERT INTO contacto (nombreusuario, emailusuario, asunto, mensaje, fecharegistro, estado) VALUES (UPPER('" . $nombre . "'), UPPER('" . $email . "'), '" . $asunto . "', '" . $mensaje . "', sysdate(), 'ACTIVO')";
        $respuesta = $con->query($query);
        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});
//******************************************************************************
//Servicio para registrar el formulario de contacto
//David
$app->get('/getDecoraciones', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM decoraciones WHERE vigencia='1' ORDER BY id_decoracion DESC";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['id_decoracion'] = $row["id_decoracion"];
                $objeto['nom_decora'] = $row["nom_decora"];
				$objeto['desc_decora'] = $row["desc_decora"];
                $objeto['valor'] = $row["valor"];
                $objeto['vigencia'] = $row["vigencia"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar una reserva
$app->post('/registrarReserva', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $telefono = $r->telefono;
        $hora = $r->hora;
        $motivo = $r->motivo;
        $fecha = $r->fecha;
        $nroPersonas = $r->nroPersonas;
        $decoracion = $r->decoracion;
        $email = $r->email;
        $idPersona = $r->idPersona;


        $queryUpdate = "UPDATE persona p SET p.telefono = '" . $telefono . "', p.email = '" . $email . "' WHERE p.id_persona = " . $idPersona;

        $ejectQueryUpdate = $con->query($queryUpdate);

        $fechaReserva = $fecha . " " . $hora;

        $queryInsert = "INSERT INTO reserva VALUES (null, '" . $idPersona . "', 'Sin Pagar', NOW(), '" . $fechaReserva . "', 0, 'Pagina Web', '" . $nroPersonas . "', '" . $motivo . "', '" . $decoracion . "', '0')";

        $respuestaInsert = $con->query($queryInsert);
        
        mail($email, " ", "Señor usuario su reserva ha sido registrada de forma exitosa.", "Reserva exitosa");
        
        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para consultar las reservas por id persona
//David
$app->post('/misReservas', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $idPersona = $r->idPersona;


        $query = "SELECT * FROM reserva r WHERE r.id_persona_reserva = " . $idPersona . " AND r.id_reserva = (SELECT MAX(s.id_reserva) FROM reserva s WHERE s.id_reserva = r.id_reserva) ORDER BY r.fecha_creacion DESC LIMIT 5";

        $respuesta = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($respuesta as $row) {
                $objeto = Array();
                $objeto['id_reserva'] = $row["id_reserva"];
                $objeto['estado'] = $row["estado"];
                $objeto['fecha_creacion'] = $row["fecha_creacion"];
                $objeto['fecha_reserva'] = $row["fecha_reserva"];
                $objeto['num_personas'] = $row["num_personas"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para envio de correo electronico
$app->post('/createQr', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $urlPicture = $r->urlPicture;


        $response["object"] = $urlPicture;
        $response["status"] = "SUCCESS";
        $response["message"] = "Consulta exitosa";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para envio de correo electronico
$app->post('/sentMail', function() use ($app) {
    try {
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $email = $r->email;
        $mensaje = $r->mensaje;

        mail($email, $nombre, $mensaje, "Registro exitoso");
        
        $response["status"] = "SUCCESS";
        $response["message"] = "Correo enviado de forma exitosa";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar el formulario de contacto
//David
$app->post('/getValor', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nodocumento = $r->nodocumento;

        $queryTotal = "SELECT *
                        FROM reserva r 
                        INNER JOIN persona p ON p.id_persona = r.id_persona_reserva 
                        LEFT JOIN decoraciones d ON d.id_decoracion = r.id_decoracion 
                        WHERE p.nodocumento = '".$nodocumento."' AND r.estado = 'Sin Pagar'
                        AND r.id_reserva = (SELECT MAX(r2.id_reserva)
                                           	FROM reserva r2
                                           	INNER JOIN persona p ON p.id_persona = r2.id_persona_reserva 
                                            LEFT JOIN decoraciones d ON d.id_decoracion = r2.id_decoracion 
                                            WHERE p.nodocumento = '".$nodocumento."' AND r2.estado = 'Sin Pagar')";
                                            
        $queryValor = $con->query($queryTotal);
    
        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetornoValor = Array();
            $count = 0;
            foreach ($queryValor as $row) {
                $objeto = Array();
                $objeto['valor'] = $row["valor"];
                $listaRetornoValor[$count] = $objeto;
                $count++;
            }
        }
    
        $response["object"] = $listaRetornoValor;
        $response["status"] = "SUCCESS";
        $response["message"] = "Consulta exitosa";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar el formulario de contacto
//David
$app->post('/getParametros', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nodocumento = $r->nodocumento;
        $numPersonas = $r->numPersonas;
        $codReserva = $r->codReserva;
        $total = $r->total + 30000;
        $prefijo = substr(md5(uniqid(rand())), 0, 6);
        $referenceCode = $prefijo . '-' . $nodocumento;
        $signature = 'gZM7VJjplt6SW61ll84hTQB4kM~763193~' . $referenceCode . '~' . $total . '~COP';
        $signature = md5($signature);

        $query = "SELECT * FROM parametros_pay";

        $listDecora = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($listDecora as $row) {
                $objeto = Array();
                $objeto['accountId'] = $row["accountId"];
                $objeto['currency'] = $row["currency"];
                $objeto['merchantId'] = $row["merchantId"];
                $objeto['prefijo'] = $prefijo;
                $objeto['referenceCode'] = $referenceCode;
                $objeto['signature'] = $signature;
                $objeto['total'] = $total;
                $objeto['codReserva'] = $codReserva;
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});
//******************************************************************************
//Servicio para registrar el formulario de contacto
//David
$app->get('/actualizaReservas', function() {
    $response = array();
    try {
        $con = new conectar();
        
        $queryReservasPasadas = "SELECT * FROM reserva r WHERE r.estado = 'Abierta' AND DATE_ADD(r.fecha_reserva, INTERVAL 35 MINUTE) < '" . date("Y-m-d H:i:s")."'";

        $listReservasPasadas = $con->query($queryReservasPasadas);
        
        if($listReservasPasadas != null) {
            foreach ($listReservasPasadas as $row) {
                $con->query("UPDATE reserva SET estado = 'Cancelada' WHERE id_reserva = '" . $row["id_reserva"] . "';");
            }
            $response["status"] = "SUCCESS";
            $response["message"] = "Con registros";
        }else{
            $response["status"] = "SUCCESS";
            $response["message"] = "Sin registros";
        }

        
        
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});