<?php

header('Access-Control-Allow-Origin: *');
header("Content-Type: text/html;charset=utf-8;charset=latin1");
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
//******************************************************************************
//Servicios del administrador
//******************************************************************************
//Servicio para traer las calificaciones
$app->get('/admCalificacion', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM calificacion c INNER JOIN persona p ON p.id_persona = c.id_persona ORDER BY c.fecha_ingreso";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['calificacion'] = $row["calificacion"];
                $objeto['fechaRegistro'] = $row["fecha_ingreso"];
                $objeto['observacion'] = $row["observaciones"];
                $objeto['nombres'] = $row["nombres"];
                $objeto['apellidos'] = $row["apellidos"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});
//******************************************************************************
//Servicio para obtener la cantidad de calificaciones
$app->get('/admCountCalificacion', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT (SELECT COUNT(1) FROM calificacion WHERE calificacion = 'Negativamente') AS caliNegativa, (SELECT COUNT(1) FROM calificacion WHERE calificacion = 'Positivamente') AS caliPositiva FROM DUAL;";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['caliNegativa'] = $row["caliNegativa"];
                $objeto['caliPositiva'] = $row["caliPositiva"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener los usuarios
$app->get('/admGetUsuarios', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM usuarios";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['id_usuario'] = $row["id_usuario"];
                $objeto['email'] = $row["email"];
                $objeto['rol'] = $row["rol"];
                $objeto['usuario'] = $row["usuario"];
                $objeto['nombre'] = $row["nombre"];
                $objeto['estado'] = $row["estado"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para actualizar la información del usuario
$app->post('/admActualizarUsuario', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $idUsuario = $r->idUsuario;
        $idRol = $r->idRol;
        $idEstado = $r->idEstado;
        $password = $r->password;

        $queryUpdate = "UPDATE usuarios SET rol = '" . $idRol . "', estado = '" . $idEstado . "', clave = '" . md5($password) . "' WHERE id_usuario = '" . $idUsuario . "'";

        $respuestaUpdate = $con->query($queryUpdate);
        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener las reservas
$app->get('/admGetReservas', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM reserva r INNER JOIN persona p ON p.id_persona = r.id_persona_reserva LEFT JOIN reserva_decoracion d ON d.id_reserva = r.id_reserva LEFT JOIN decoraciones c2 ON c2.id_decoracion = d.id_decoracion LEFT JOIN decoraciones c ON c.id_decoracion = r.id_decoracion ORDER BY fecha_creacion DESC";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['id_reserva'] = $row["id_reserva"];
                $objeto['estado'] = $row["estado"];
                $objeto['fecha_creacion'] = $row["fecha_creacion"];
                $objeto['fecha_reserva'] = $row["fecha_reserva"];
                $objeto['Origen'] = $row["Origen"];
                $objeto['num_personas'] = $row["num_personas"];
                $objeto['nombres'] = $row["nombres"];
                //$objeto['apellidos'] = $row["apellidos"];
                $objeto['nodocumento'] = $row["nodocumento"];
                $objeto['telefono'] = $row["telefono"];
                $objeto['email'] = $row["email"];
                $objeto['genero'] = $row["genero"];
                $objeto['nom_decora'] = $row["nom_decora"];
                $objeto['desc_decora'] = $row["desc_decora"];
                $objeto['valor'] = $row["valor"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener el menú
$app->post('/admGetMenu', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $idCategoria = $r->idCategoria;

//        $query = "SELECT * FROM menu m INNER JOIN categoria_contenido t ON t.id_categoria = m.id_categoria WHERE m.id_categoria = " . $idCategoria . "";

        $query = "SELECT * FROM contenido c INNER JOIN categoria_contenido t ON t.id_categoria = c.id_cat_cont WHERE c.id_cat_cont = " . $idCategoria . "";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
//                $objeto['menu_id'] = $row["menu_id"];
//                $objeto['id_categoria'] = $row["id_categoria"];
//                $objeto['menu_titulo'] = $row["menu_titulo"];
//                $objeto['menu_des'] = $row["menu_des"];
//                $objeto['menu_path'] = $row["menu_path"];
//                $objeto['menu_precio'] = $row["menu_precio"];

                $objeto['id_contenido'] = $row["id_contenido"];
                $objeto['fecha_creacion'] = $row["fecha_creacion"];
                $objeto['nombre_contenido'] = $row["nombre_contenido"];
                $objeto['desc_corta_contenido'] = $row["desc_corta_contenido"];
                $objeto['desc_contenido'] = $row["desc_contenido"];
               //$objeto['imagen'] = $row["imagen"];
                $objeto['valor_unitario'] = $row["valor_unitario"];
                $objeto['vigencia'] = $row["vigencia"];
                $objeto['id_cat_cont'] = $row["id_cat_cont"];
                $objeto['base64_imagen'] = $row["base64_imagen"];

                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener el menú
$app->get('/admGetCategorias', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM categoria_contenido";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['id_categoria'] = $row["id_categoria"];
                $objeto['nombre_categoria'] = $row["nombre_categoria"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});


//******************************************************************************
//Servicio para obtener el menú
$app->get('/admGetCotizacion', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM cotizacion ORDER BY cot_id DESC";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['cot_nombre'] = $row["cot_nombre"];
                $objeto['cot_tel'] = $row["cot_tel"];
                $objeto['cot_empresa'] = $row["cot_empresa"];
                $objeto['cot_celular'] = $row["cot_celular"];
                $objeto['cot_ciudad'] = $row["cot_ciudad"];
                $objeto['cot_email'] = $row["cot_email"];
                $objeto['cot_locacion'] = $row["cot_locacion"];
                $objeto['cot_fecha'] = $row["cot_fecha"];
                $objeto['cot_evento'] = $row["cot_evento"];
                $objeto['cot_hservicio'] = $row["cot_hservicio"];
                $objeto['cot_hingreso'] = $row["cot_hingreso"];
                $objeto['cot_hsalida'] = $row["cot_hsalida"];
                $objeto['cot_npersonas'] = $row["cot_npersonas"];
                $objeto['cot_menores'] = $row["cot_menores"];
                $objeto['cot_presupuesto'] = $row["cot_presupuesto"];
                $objeto['cot_detalle'] = $row["cot_detalle"];
                $objeto['cot_total'] = $row["cot_total"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener los eventos
$app->get('/admGetEventos', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM eventos ORDER BY fecha_evento";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['id_evento'] = $row["id_evento"];
                $objeto['nombre_evento'] = $row["nombre_evento"];
                $objeto['desc_evento'] = $row["desc_evento"];
                $objeto['imagen_evento'] = $row["imagen_evento"];
                $objeto['fecha_evento'] = $row["fecha_evento"];
                $objeto['evento_estado'] = $row["evento_estado"];
                $objeto['base64_imagen'] = $row["base64_imagen"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener los eventos
$app->post('/admCotizar', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());

        $cliente = $r->cliente;

        $empresa = $r->empresa;
        $telefono = $r->telefono;
        $celular = $r->celular;
        $ciudad = $r->ciudad;
        $email = $r->email;
        $locacion = $r->locacion;
        $fecha = $r->fecha;
        $evento = $r->evento;
        $horass = $r->horass;
        $horai = $r->horai;
        $horas = $r->horas;
        $personas = $r->personas;
        $menores = $r->menores;
        $presupuesto = $r->presupuesto;
        $detalle = $r->detalle;
        $total = $r->total;

        $queryInsert = "INSERT INTO cotizacion (cot_id,cot_nombre,cot_tel,cot_empresa,cot_celular,cot_ciudad,cot_email,cot_locacion,cot_fecha,cot_evento,cot_hservicio,cot_hingreso,cot_hsalida,cot_npersonas,cot_menores,cot_presupuesto,cot_detalle,cot_total)" .
                " VALUES (NULL, UPPER('" . $cliente . "'), '" . $telefono . "', '" . $empresa . "', '" . $celular . "', UPPER('" . $ciudad . "'), '" . $email . "','" . $locacion . "','" . $fecha . "','" . $evento . "','" . $horass . "','" . $horai . "','" . $horas . "','" . $personas . "','" . $menores . "','" . $presupuesto . "','" . $detalle . "','" . $total . "')";

        $respuestaInsert = $con->query($queryInsert);
        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para obtener las promociones
$app->get('/admGetPromocion', function() {
    $response = array();
    try {
        $con = new conectar();

        $query = "SELECT * FROM promociones";
        //$query = "SELECT * FROM promociones";

        $list = $con->query($query);

        if ($con->num_rows() == 0) {
            $response["status"] = "ERROR";
            $response['message'] = "No registra información";
        } else {
            $listaRetorno = Array();
            $count = 0;
            foreach ($list as $row) {
                $objeto = Array();
                $objeto['id_promo'] = $row["id_promo"];
                $objeto['nom_promo'] = $row["nom_promo"];
                $objeto['desc_promo'] = $row["desc_promo"];
                $objeto['valor_promo'] = $row["valor_promo"];
                $objeto['img_promo'] = $row["img_promo"];
                $objeto['vigente_promo'] = $row["vigente_promo"];
                $objeto['base64_imagen'] = $row["base64_imagen"];
                $listaRetorno[$count] = $objeto;
                $count++;
            }
            $response["object"] = $listaRetorno;
            $response["status"] = "SUCCESS";
            $response["message"] = "Consulta exitosa";
        }
    } catch (Exception $e) {
        $response["status"] = "ERROR";
        $response['message'] = "Servidor dice : " . $e->getMessage();
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar una promocion
$app->post('/admRegistrarPromocion', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $valor = $r->valor;
        $descripcion = $r->descripcion;
        $nombreArchivo = $r->nombreArchivo;
        $imagen = $r->imagen;

        $queryInsert = "INSERT INTO promociones(id_promo, nom_promo, desc_promo, valor_promo, img_promo, vigente_promo, base64_imagen) "
                . "VALUES (NULL, '" . $nombre . "', '" . $descripcion . "', '" . $valor . "', 'SIN_IMAGEN', 1, '".$imagen."')";

        $respuestaInsert = $con->query($queryInsert);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar un menu
$app->post('/admRegistrarMenu', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $valor = $r->valor;
        $categoria = $r->categoria;
        $descCorta = $r->descCorta;
        $descripcion = $r->descripcion;
        $nombreArchivo = $r->nombreArchivo;
        $imagen = $r->imagen;

        $queryInsert = "INSERT INTO contenido (id_contenido, fecha_creacion, nombre_contenido, desc_corta_contenido, desc_contenido, imagen, valor_unitario, vigencia, id_cat_cont, base64_imagen) "
                . "VALUES (NULL, NOW(), '" . $nombre . "', '" . $descCorta . "', '" . $descripcion . "', 'SIN_IMAGEN', '" . $valor . "', 1, '" . $categoria . "', '". $imagen ."')";

        $respuestaInsert = $con->query($queryInsert);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar un evento
$app->post('/admRegistrarEvento', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $fecha = $r->fecha;
        $hora = $r->hora;
        $descripcion = $r->descripcion;
        $nombreArchivo = $r->nombreArchivo;
        $imagen = $r->imagen;

        $queryInsert = "INSERT INTO eventos(id_evento, nombre_evento, desc_evento, imagen_evento, fecha_evento, evento_estado, base64_imagen) "
                . "VALUES (NULL, '" .$nombre . "', '" . $descripcion . "', 'SIN_IMAGEN', '" . $fecha . " " . $hora . "', 1, '". $imagen ."')";

        $respuestaInsert = $con->query($queryInsert);
        
        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para envio de correo electronico
$app->post('/admSentMail', function() use ($app) {
    try {
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $email = $r->email;
        $mensaje = $r->mensaje;

        $to = $email;
        $email_subject = $nombre;
        $email_body = $mensaje;
        $headers = "Registro la cotización de forma exitosa";
        
        mail($to, $email_subject, $email_body, $headers);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});


//******************************************************************************
//Servicio para registrar una promocion
$app->post('/admActualizarPromocion', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $vigencia = $r->vigencia;
        $idPromo = $r->idPromo;

        $queryInsert = "UPDATE promociones SET vigente_promo = " .$vigencia. " WHERE id_promo = ". $idPromo;

        $respuestaInsert = $con->query($queryInsert);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";

    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para actualizar el estado de un evento
$app->post('/admActualizarEventro', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $vigencia = $r->vigencia;
        $idEventro = $r->idEventro;

        $queryInsert = "UPDATE eventos SET evento_estado = " . $vigencia . " WHERE id_evento = ". $idEventro;

        $respuestaInsert = $con->query($queryInsert);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";

    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});
//******************************************************************************
//Servicio para editar un contenido
$app->post('/admActualizarMenu', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $valor = $r->valor;
        $categoria = $r->categoria;
        $descCorta = $r->descCorta;
        $descripcion = $r->descripcion;
        $nombreArchivo = $r->nombreArchivo;
        $imagen = $r->imagen;
        $idContenido = $r->idContenido;
        
        $queryUpdate = "UPDATE contenido SET nombre_contenido='".$nombre."',desc_corta_contenido='".$descCorta."',desc_contenido='".$descripcion."',imagen='SIN_IMAGEN',valor_unitario=".$valor.",id_cat_cont=".$categoria.",base64_imagen='".$imagen."' WHERE id_contenido = ".$idContenido;

        $respuestaUpdate = $con->query($queryUpdate);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";

    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para registrar un nuevo usuario
$app->post('/admRegistrarUsuario', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $username = $r->username;
        $email = $r->email;
        $rol = $r->rol;
        $password = $r->password;

        $queryInsert = "INSERT INTO usuarios (id_usuario, email, rol, usuario, clave, nombre, estado) "
                . "VALUES (NULL, '" .$email . "', '" . $rol . "', '".$username. "', '" . md5($password) . "', '" . $nombre ."', 1)";

        $respuestaInsert = $con->query($queryInsert);
        
        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";
    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para editar un evento
$app->post('/admActualizarEvento', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $descripcion = $r->descripcion;
        $fecha = $r->fecha;
        $hora = $r->hora;
        $nombreArchivo = $r->nombreArchivo;
        $imagen = $r->imagen;
        $id = $r->id;
        
        $fechaActualizacion = $fecha;
        
        $queryUpdate = "UPDATE eventos SET nombre_evento='".$nombre."',desc_evento='".$descripcion."',imagen_evento='".$nombreArchivo."', fecha_evento='". $fechaActualizacion ."', base64_imagen='". $imagen . "' WHERE id_evento = " . $id;

        $respuestaUpdate = $con->query($queryUpdate);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";

    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});

//******************************************************************************
//Servicio para editar una promocion
$app->post('/admActualizarInfoPromocion', function() use ($app) {
    try {
        $con = new conectar();
        $response = array();
        $r = json_decode($app->request->getBody());
        $nombre = $r->nombre;
        $valor = $r->valor;
        $descripcion = $r->descripcion;
        $nombreArchivo = $r->nombreArchivo;
        $imagen = $r->imagen;
        $id = $r->id;
        
        $queryUpdate = "UPDATE promociones SET nom_promo = '".$nombre."', desc_promo = '".$descripcion."', valor_promo = ".$valor.", img_promo = 'SIN_IMAGEN', base64_imagen='". $imagen . "' WHERE id_promo = '" . $id . "'";

        $respuestaUpdate = $con->query($queryUpdate);

        $response["status"] = "SUCCESS";
        $response["message"] = "Registro exitoso";

    } catch (Exception $exc) {
        $response["status"] = "error";
        $response["message"] = $exc;
    }
    echoResponse(200, $response);
});