(function () {
    'use strict';

    angular.module('AdminPorto.controllers').controller('UsuariosCtrl', UsuariosCtrl);

    UsuariosCtrl.$inject = ['$scope', '$http'];

    function UsuariosCtrl($scope, $http) {
        console.log('<<<<controler UsuariosCtrl>>>');

//        $scope.urlBase = 'http://localhost:8050/adminPortoAlto/Administrativo/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/Administrativo/Administrativo/servicios/v1/';

        $scope.pageSize = 6;
        $scope.currentPage = 1;
        $scope.formEditUser = false;
        $scope.rol = [];
        $scope.titleDlgConfirm;
        $scope.messageDlgConfirm;
        $scope.datosFormulario = {};
        $scope.errores = {};
        $scope.userSelect;
        $scope.regExpEmail = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.([a-zA-Z]{2,4})+$/;

        $scope.getUsuarios = getUsuarios;
        $scope.editar = editar;
        $scope.regresar = regresar;
        $scope.actualizar = actualizar;
        $scope.validaCampoRol = validaCampoRol;
        $scope.validaCampoEstado = validaCampoEstado;
        $scope.validaCampoPassword = validaCampoPassword;
        $scope.confirmaActualiacion = confirmaActualiacion;
        $scope.formRegistrar = formRegistrar;
        $scope.confirmaRegistro = confirmaRegistro;
        $scope.validaRepassword = validaRepassword;
        $scope.validaCampoNombre = validaCampoNombre;
        $scope.validaCampoUsername = validaCampoUsername;
        $scope.validaEmail = validaEmail;
        $scope.validaRol = validaRol;
        $scope.validaPassword = validaPassword;
        
        function confirmaRegistro(){
            var error = false;
            if(!$scope.datosFormulario.nombre){
                $scope.errores.nombre = 'El campo es obligatorio';
                error = true;
            }
            if(!$scope.datosFormulario.username){
                $scope.errores.username = 'El campo es obligatorio';
                error = true;
            }
            if(!$scope.datosFormulario.email){
                $scope.errores.email = 'El campo es obligatorio';
                error = true;
            }else{
                if(!$scope.regExpEmail.test($scope.datosFormulario.email)){
                    $scope.errores.email = 'El campo no cumple con los parametros requeridos.';
                    error = true;
                }
            }
            if(!$scope.datosFormulario.rol){
                $scope.errores.rol = 'El campo es obligatorio';
                error = true;
            }
            if(!$scope.datosFormulario.password){
                $scope.errores.password = 'El campo es obligatorio';
                error = true;
            }
            if(!$scope.datosFormulario.repassword){
                $scope.errores.repassword = 'El campo es obligatorio';
                error = true;
            }else{
                if($scope.datosFormulario.password !== $scope.datosFormulario.repassword){
                    $scope.errores.repassword = 'Los datos no son similares.';
                    error = true;
                }
            }
            if(!error){
                $scope.datos = {};
                $scope.datos.nombre = $scope.datosFormulario.nombre;
                $scope.datos.username = $scope.datosFormulario.username;
                $scope.datos.email = $scope.datosFormulario.email;
                $scope.datos.rol = $scope.datosFormulario.rol.id;
                $scope.datos.password = $scope.datosFormulario.password;
                $http.post($scope.urlBase + 'admRegistrarUsuario', $scope.datos)
                        .success(function (data, status, header, config) {
                            if (data.status === 'SUCCESS') {
                                $('#dlgRegistrar').modal('hide');
                                $('#dlgSuccess').modal();
                                $scope.mensajeExito = 'Se registro el usuario de forma exitosa.';
                                $scope.datosFormulario = {};
                                getUsuarios()
                            }
                        }).error(function (data, status, header, config) {
                    alert('Error al consultar la información');
                });
            }
        }
        
        function validaRepassword(){
            if($scope.datosFormulario.password){
                if($scope.datosFormulario.password !== $scope.datosFormulario.repassword){
                    $scope.errores.repassword = 'Los datos no son similares.';
                }else{
                    $scope.errores.repassword = '';
                }
            }else{
                $scope.errores.password = 'El campo es obligatorio';
            }
        }
        
        function formRegistrar(){
            $('#dlgRegistrar').modal({backdrop: 'static', keyboard: false});
        }

        function confirmaActualiacion() {
            $('#dlgConfirmar').modal('hide');
            $scope.datos = {};
            $scope.datos.idUsuario = $scope.userSelect.id_usuario;
            $scope.datos.idRol = $scope.datosFormulario.rol.id;
            $scope.datos.idEstado = $scope.datosFormulario.estado;
            $scope.datos.password = $scope.datosFormulario.password;
            $http.post($scope.urlBase + 'admActualizarUsuario', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $('#dlgSuccess').modal();
                            $scope.mensajeExito = 'Se actualizó la información de forma exitosa.';
                            $scope.datosFormulario = {};
                            $scope.formEditUser = false;
                            getUsuarios()
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function validaCampoRol() {
            if ($scope.datosFormulario.rol) {
                $scope.errores.rol = '';
            }
        }

        function validaCampoEstado() {
            if ($scope.datosFormulario.estado) {
                $scope.errores.estado = '';
            }
        }

        function validaCampoPassword() {
            if ($scope.datosFormulario.password) {
                $scope.errores.password = '';
            }
        }

        function actualizar() {
            var error = false;
            if (!$scope.datosFormulario.rol) {
                $scope.errores.rol = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.estado) {
                $scope.errores.estado = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.password) {
                $scope.errores.password = 'El campo es obligatorio';
                error = true;
            }
            if (!error) {
                $scope.titleDlgConfirm = 'Actualizar información usuario';
                $scope.messageDlgConfirm = 'Señor usuario, se encuentra seguro de actualizar la información.';
                $('#dlgConfirmar').modal({backdrop: 'static', keyboard: false});
            }
        }

        function regresar() {
            $scope.formEditUser = false;
        }

        function editar(item) {
            $scope.formEditUser = true;
            $scope.userSelect = item;
        }

        function getUsuarios() {
            $http.get($scope.urlBase + 'admGetUsuarios')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.usuarios = data.object;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }
        
        function validaPassword(){
            if($scope.datosFormulario.password){
                $scope.errores.password = '';
            }
        }
        
        function validaRol(){
            if($scope.datosFormulario.rol){
                $scope.errores.rol = '';
            }
        }
        
        function validaEmail(){
            if($scope.datosFormulario.email){
                if(!$scope.regExpEmail.test($scope.datosFormulario.email)){
                    $scope.errores.email = 'El campo no cumple con los parametros requeridos.';
                }else{
                    $scope.errores.email = '';
                }
            }
        }
        
        function validaCampoUsername(){
            if($scope.datosFormulario.username){
                $scope.errores.username = '';
            }
        }
        
        function validaCampoNombre(){
            if($scope.datosFormulario.nombre){
                $scope.errores.nombre = '';
            }
        }

        $scope.rolVigilante = {id: 0, detalle: 'Vigilante'};
        $scope.rolBartender = {id: 1, detalle: 'Bartender'};
        $scope.rolAdministrador = {id: 2, detalle: 'Administrador'};

        $scope.rol.push($scope.rolVigilante);
        $scope.rol.push($scope.rolBartender);
        $scope.rol.push($scope.rolAdministrador);

        getUsuarios();

    }

})();