(function () {
    'use strict';
    
    angular.module('AdminPorto.controllers').controller('ReservaCtrl', ReservaCtrl);
    
    ReservaCtrl.$inject = ['$scope', '$http'];
    
    function ReservaCtrl($scope, $http) {
        console.log('<<<<controler ReservaCtrl>>>');
        
//        $scope.urlBase = 'http://localhost:8050/adminPortoAlto/Administrativo/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/Administrativo/Administrativo/servicios/v1/';
        
        $scope.pageSize = 6;
        $scope.currentPage = 1;
        
        $scope.getReservas = getReservas;
        $scope.verDetalle = verDetalle;
        
        function verDetalle(item) {
            $('#dlgDetalleReserva').modal({backdrop: 'static', keyboard: false});
            $scope.itemSelect = item;
        }
        
        function getReservas() {
            $http.get($scope.urlBase + 'admGetReservas')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultadoReservas = data.object;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }
        
        getReservas();
        
    }
    
})();