(function () {
    'use strict';

    angular.module('AdminPorto.controllers').controller('PromocionCtrl', PromocionCtrl);

    PromocionCtrl.$inject = ['$scope', '$http'];

    function PromocionCtrl($scope, $http) {
        console.log('<<<<controler PromocionCtrl>>>');

//        $scope.urlBase = 'http://localhost:8050/adminPortoAlto/Administrativo/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/Administrativo/Administrativo/servicios/v1/';

        $scope.pageSize = 6;
        $scope.currentPage = 1;
        $scope.showResultado = true;
        $scope.showFormRegistrar = false;
        $scope.errores = {};
        $scope.datosFormulario = {};
        $scope.regExpNumero = /^[0-9]*$/;
        $scope.itemSelect;

        $scope.getPromocion = getPromocion;
        $scope.verImagen = verImagen;
        $scope.formRegistrar = formRegistrar;
        $scope.cancelar = cancelar;
        $scope.registrar = registrar;
        $scope.validaCampoNombre = validaCampoNombre;
        $scope.validaCampoValor = validaCampoValor;
        $scope.validaCampoDescripcion = validaCampoDescripcion;
        $scope.confirmaRegistro = confirmaRegistro;
        $scope.cambiarEstadoPromo = cambiarEstadoPromo;
        $scope.editar = editar;
        $scope.confirmaActualizacion = confirmaActualizacion;
        
        function confirmaActualizacion(){
            $scope.datos = {};
            $scope.datos.nombre = $scope.datosFormulario.nom_promo;
            $scope.datos.valor = $scope.datosFormulario.valor_promo;
            $scope.datos.descripcion = $scope.datosFormulario.descripcion;
            $scope.datos.imagen = $('#archivo2').val();
            $scope.datos.id = $scope.itemSelect.id_promo;
            if(!$scope.datos.imagen){
                $scope.datos.nombreArchivo = 'SIN_IMAGEN';
                $scope.datos.imagen = $scope.itemSelectUpdate.base64_imagen;
            }else{
                $scope.datos.nombreArchivo = 'SIN_IMAGEN';
                $scope.datos.imagen = $('#archivo2').val();
            }
            //console.log(JSON.stringify($scope.datos));
            $http.post($scope.urlBase + 'admActualizarInfoPromocion', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.datosFormulario = {};
                            $('#dlgEdit').modal('hide');
                            $('#dlgSuccessUpdate').modal({backdrop: 'static', keyboard: false});
                            cancelar();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }
        
        function editar(item){
            $scope.itemSelect = item;
            $('#dlgEdit').modal({backdrop: 'static', keyboard: false});
        }

        function cambiarEstadoPromo(item, id) {
            $scope.datos = {};
            $scope.datos.vigencia = id;
            $scope.datos.idPromo = item.id_promo;
            $http.post($scope.urlBase + 'admActualizarPromocion', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            if(id === 0){
                                $('#dlgConfirmar').modal('hide');
                                $('#dlgInactivar').modal({backdrop: 'static', keyboard: false});
                            }
                            if(id === 1){
                                $('#dlgConfirmar').modal('hide');
                                $('#dlgActivar').modal({backdrop: 'static', keyboard: false});
                            }
                            cancelar();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function confirmaRegistro() {
            $scope.datos = {};
            $scope.datos.nombre = $scope.datosFormulario.nombre;
            $scope.datos.valor = $scope.datosFormulario.valor;
            $scope.datos.descripcion = $scope.datosFormulario.descripcion;
            $scope.datos.nombreArchivo = $('#nombre').val();
            $scope.datos.imagen = $('#archivo').val();
            $http.post($scope.urlBase + 'admRegistrarPromocion', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $('#dlgConfirmar').modal('hide');
                            $('#dlgSuccess').modal({backdrop: 'static', keyboard: false});
                            cancelar();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function registrar() {
            var error = false;
            if (!$scope.datosFormulario.nombre) {
                error = true;
                $scope.errores.nombre = 'El campo es obligatorio';
            }
            if (!$scope.datosFormulario.valor) {
                error = true;
                $scope.errores.valor = 'El campo es obligatorio';
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.valor)) {
                    error = true;
                    $scope.errores.valor = 'El campo debe ser numerico';
                }
            }
            if (!$scope.datosFormulario.descripcion) {
                error = true;
                $scope.errores.descripcion = 'El campo es obligatorio';
            }
            $scope.nombreArchivo = $('#archivo').val();
            if (!$scope.nombreArchivo) {
                $scope.errores.fileadjunto = 'El campo es obligatorio';
                error = true;
            }
            if (!error) {
                $('#dlgConfirmar').modal({backdrop: 'static', keyboard: false});
            }
        }

        function cancelar() {
            $scope.errores = {};
            $scope.datosFormulario = {};
            $scope.showResultado = true;
            $scope.showFormRegistrar = false;
            getPromocion();
        }

        function formRegistrar() {
            $scope.showResultado = false;
            $scope.showFormRegistrar = true;
        }

        function verImagen(item) {
            $scope.selectItem = "data:image/jpg;base64," + item;
            $('#dlgVerImagen').modal({backdrop: 'static', keyboard: false});
        }

        function getPromocion() {
            $http.get($scope.urlBase + 'admGetPromocion')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultadoPromocion = data.object;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function validaCampoDescripcion() {
            if ($scope.datosFormulario.descripcion) {
                $scope.errores.descripcion = '';
            }
        }

        function validaCampoValor() {
            if ($scope.datosFormulario.valor) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.valor)) {
                    $scope.errores.valor = 'El campo debe ser numerico';
                } else {
                    $scope.errores.valor = '';
                }
            }
        }

        function validaCampoNombre() {
            if ($scope.datosFormulario.nombre) {
                $scope.errores.nombre = '';
            }
        }

        getPromocion();

    }

})();