(function () {
    'use strict';

    angular.module('AdminPorto.controllers').controller('MenuCtrl', MenuCtrl);

    MenuCtrl.$inject = ['$scope', '$http'];

    function MenuCtrl($scope, $http) {
        console.log('<<<<controler MenuCtrl>>>');

//        $scope.urlBase = 'http://localhost:8050/adminPortoAlto/Administrativo/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/Administrativo/Administrativo/servicios/v1/';

        $scope.pageSize = 6;
        $scope.currentPage = 1;
        $scope.entradas = [];
        $scope.resultadoMenu;
        $scope.showFormNuevo = false;
        $scope.errores = {};
        $scope.datosFormulario = {};
        $scope.itemSelectUpdate;
        $scope.datosActualizar = {};

        $scope.getMenu = getMenu;
        $scope.changetab = changetab;
        $scope.verDetalle = verDetalle;
        $scope.formRegistrar = formRegistrar;
        $scope.cancelar = cancelar;
        $scope.getCategotias = getCategotias;
        $scope.registrar = registrar;
        $scope.validaCampoNombre = validaCampoNombre;
        $scope.validaCampoValor = validaCampoValor;
        $scope.validaCampoCategoria = validaCampoCategoria;
        $scope.validaCampoDescCorta = validaCampoDescCorta;
        $scope.validaCampoDescripcion = validaCampoDescripcion;
        $scope.confirmaRegistro = confirmaRegistro;
        $scope.editar = editar;
        $scope.confirmaActualizacion = confirmaActualizacion;
        
        function confirmaActualizacion(){
            $scope.datos = {};
            $scope.datos.nombre = $scope.itemSelectUpdate.nombre_contenido;
            $scope.datos.valor = $scope.itemSelectUpdate.valor_unitario;
            if(!$scope.datosActualizar.categoria){
                $scope.datos.categoria = $scope.itemSelectUpdate.id_cat_cont;
            }else{
                $scope.datos.categoria = $scope.datosActualizar.categoria.id_categoria;
            }
            $scope.datos.descCorta = $scope.itemSelectUpdate.desc_corta_contenido;
            $scope.datos.descripcion = $scope.itemSelectUpdate.desc_contenido;
            $scope.datos.nombreArchivo = $('#nombre2').val();
            $scope.datos.imagen = $('#archivo2').val();
            if(!$scope.datos.imagen){
                $scope.datos.nombreArchivo = 'SIN_IMAGEN';
                $scope.datos.imagen = $scope.itemSelectUpdate.base64_imagen;
            }else{
                $scope.datos.nombreArchivo = 'SIN_IMAGEN';
                $scope.datos.imagen = $('#archivo2').val();
            }
            $scope.datos.idContenido = $scope.itemSelectUpdate.id_contenido;
            $http.post($scope.urlBase + 'admActualizarMenu', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $('#dlgEdit').modal('hide');
                            $('#dlgSuccessUpdate').modal({backdrop: 'static', keyboard: false});
                            cancelar();
                            getMenu(1);
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }
        
        function editar(item){
            getCategotias();
            $scope.itemSelectUpdate = item;
            $('#dlgEdit').modal({backdrop: 'static', keyboard: false});
        }

        function confirmaRegistro() {
            $scope.datos = {};
            $scope.datos.nombre = $scope.datosFormulario.nombre;
            $scope.datos.valor = $scope.datosFormulario.valor;
            $scope.datos.categoria = $scope.datosFormulario.categoria.id_categoria;
            $scope.datos.descCorta = $scope.datosFormulario.descCorta;
            $scope.datos.descripcion = $scope.datosFormulario.descripcion;
            $scope.datos.nombreArchivo = $('#nombre').val();
            $scope.datos.imagen = $('#archivo').val();
            $http.post($scope.urlBase + 'admRegistrarMenu', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $('#dlgConfirmar').modal('hide');
                            $('#dlgSuccess').modal({backdrop: 'static', keyboard: false});
                            cancelar();
                            getMenu(1);
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function registrar() {
            var error = false;
            if (!$scope.datosFormulario.nombre) {
                $scope.errores.nombre = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.valor) {
                $scope.errores.valor = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.categoria) {
                $scope.errores.categoria = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.descCorta) {
                $scope.errores.descCorta = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.descripcion) {
                $scope.errores.descripcion = 'El campo es obligatorio.';
                error = true;
            }
            $scope.nombreArchivo = $('#archivo').val();
            if (!$scope.nombreArchivo) {
                $scope.errores.fileadjunto = 'El campo es obligatorio';
                error = true;
            }
            if (!error) {
                $('#dlgConfirmar').modal({backdrop: 'static', keyboard: false});
            }
        }

        function validaCampoDescripcion() {
            if ($scope.datosFormulario.descripcion) {
                $scope.errores.descripcion = '';
            }
        }

        function validaCampoDescCorta() {
            if ($scope.datosFormulario.descCorta) {
                $scope.errores.descCorta = '';
            }
        }

        function validaCampoCategoria() {
            if ($scope.datosFormulario.categoria) {
                $scope.errores.categoria = '';
            }
        }

        function validaCampoValor() {
            if ($scope.datosFormulario.valor) {
                $scope.errores.valor = '';
            }
        }

        function validaCampoNombre() {
            if ($scope.datosFormulario.nombre) {
                $scope.errores.nombre = '';
            }
        }

        function getCategotias() {
            $http.get($scope.urlBase + 'admGetCategorias')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.categorias = data.object;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function cancelar() {
            $scope.showFormNuevo = false;
            changetab(1);
        }

        function formRegistrar() {
            $scope.datosFormulario = {};
            $scope.showFormNuevo = true;
            getCategotias();
        }

        function verDetalle(item) {
            $scope.selectItem = item;
            $('#dlgVerImagen').modal({backdrop: 'static', keyboard: false});
        }

        function getMenu(param) {
            $scope.resultadoMenu;
            $scope.dato = {};
            $scope.dato.idCategoria = param;
            $http.post($scope.urlBase + 'admGetMenu', $scope.dato)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultadoMenu = data.object;
                        } else {
                            $scope.resultadoMenu = [];
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function changetab(index) {
            getMenu(index);
            if (index === 1) {
                $scope.form1 = true;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 2) {
                $scope.form1 = false;
                $scope.form2 = true;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 3) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = true;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 4) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = true;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 5) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = true;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 6) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = true;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 7) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = true;
                $scope.form8 = false;
                $scope.form9 = false;
            } else if (index === 8) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = true;
            } else if (index === 9) {
                $scope.form1 = false;
                $scope.form2 = false;
                $scope.form3 = false;
                $scope.form4 = false;
                $scope.form5 = false;
                $scope.form6 = false;
                $scope.form7 = false;
                $scope.form8 = false;
                $scope.form9 = true;
            }
        }

        changetab(1);
    }

})();