(function () {
    'use strict';

    angular.module('AdminPorto.controllers').controller('EventoCtrl', EventoCtrl);

    EventoCtrl.$inject = ['$scope', '$http'];

    function EventoCtrl($scope, $http) {
        console.log('<<<<controler EventoCtrl>>>');

//        $scope.urlBase = 'http://localhost:8050/adminPortoAlto/Administrativo/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/Administrativo/Administrativo/servicios/v1/';

        $scope.pageSize = 6;
        $scope.currentPage = 1;
        $scope.showFormInfo = true;
        $scope.showFormSinInfo = false;
        $scope.showFormRegistrar = false;
        $scope.selectHora = [];
        $scope.errores = {};
        $scope.datosFormulario = {};
        $scope.itemSelect;

        $scope.getEventos = getEventos;
        $scope.registrarEvento = registrarEvento;
        $scope.registrar = registrar;
        $scope.validaCampoDescCorta = validaCampoDescCorta;
        $scope.validaCampoHora = validaCampoHora;
        $scope.validaCampoFecha = validaCampoFecha;
        $scope.validaCampoNombre = validaCampoNombre;
        $scope.confirmaRegistro = confirmaRegistro;
        $scope.cancelar = cancelar;
        $scope.verDetalle = verDetalle;
        $scope.inactivarEvento = inactivarEvento;
        $scope.editar = editar;
        $scope.confirmaActualizacion = confirmaActualizacion;
        
        function confirmaActualizacion(){
            $scope.datos = {};
            $scope.datos.nombre = $scope.datosFormulario.nombreEvento;
            $scope.datos.descripcion = $scope.datosFormulario.descripcion;
            $scope.datos.fecha = $scope.datosFormulario.fecha;
            $scope.datos.hora = $scope.datosFormulario.hora;
            $scope.datos.nombreArchivo = $('#nombre2').val();
            $scope.datos.imagen = $('#archivo2').val();
            $scope.datos.id = $scope.itemSelect.id_evento;
            if(!$scope.datos.imagen){
                $scope.datos.nombreArchivo = 'SIN_IMAGEN';
                $scope.datos.imagen = $scope.itemSelectUpdate.base64_imagen;
            }else{
                $scope.datos.nombreArchivo = 'SIN_IMAGEN';
                $scope.datos.imagen = $('#archivo2').val();
            }
            $http.post($scope.urlBase + 'admActualizarEvento', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.datosFormulario = {};
                            $('#dlgEdit').modal('hide');
                            $('#dlgSuccessUpdate').modal({backdrop: 'static', keyboard: false});
                            cancelar();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }
        
        function editar(item){
            $scope.itemSelect = item;
            $('#dlgEdit').modal({backdrop: 'static', keyboard: false});
        }
        
        function inactivarEvento(item, id){
            $scope.datos = {};
            $scope.datos.vigencia = id;
            $scope.datos.idEventro = item.id_evento;
            $http.post($scope.urlBase + 'admActualizarEventro', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            if(id === 0){
                                $('#dlgConfirmar').modal('hide');
                                $('#dlgInactivar').modal({backdrop: 'static', keyboard: false});
                                cancelar();
                                getEventos();
                            }
                            if(id === 1){
                                $('#dlgConfirmar').modal('hide');
                                $('#dlgActivar').modal({backdrop: 'static', keyboard: false});
                                cancelar();
                                getEventos();
                            }
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }
        
        function verDetalle(item) {
            $scope.selectItem = "data:image/jpg;base64," + item
            $('#dlgVerImagen').modal({backdrop: 'static', keyboard: false});
        }

        function cancelar() {
            $scope.errores = {};
            $scope.datosFormulario = {};
            $scope.showFormInfo = true;
            $scope.showFormSinInfo = false;
            $scope.showFormRegistrar = false;
            getEventos();
        }

        function confirmaRegistro() {
            $scope.datos = {};
            $scope.datos.nombre = $scope.datosFormulario.nombre;
            $scope.datos.fecha = $scope.datosFormulario.fecha;
            $scope.datos.hora = $scope.datosFormulario.hora.descripcion;
            $scope.datos.descripcion = $scope.datosFormulario.descripcion;
            $scope.datos.nombreArchivo = $('#nombre').val();
            $scope.datos.imagen = $('#archivo').val();
            $http.post($scope.urlBase + 'admRegistrarEvento', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $('#dlgConfirmar').modal('hide');
                            $('#dlgSuccess').modal({backdrop: 'static', keyboard: false});
                            cancelar();
                            getEventos();
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        function registrar() {
            var error = false;
            if (!$scope.datosFormulario.nombre) {
                $scope.errores.nombre = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.fecha) {
                $scope.errores.fecha = 'El campo es obligatorio.';
                error = true;
            }
            if (!$scope.datosFormulario.hora) {
                $scope.errores.hora = 'El campo es obligatorio.';
                error = true;
            }
            $scope.nombreArchivo = $('#archivo').val();
            if (!$scope.nombreArchivo) {
                $scope.errores.fileadjunto = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.descripcion) {
                $scope.errores.descripcion = 'El campo es obligatorio.';
                error = true;
            }
            if (!error) {
                $('#dlgConfirmar').modal({backdrop: 'static', keyboard: false});
            }
        }

        function validaCampoNombre() {
            if ($scope.datosFormulario.nombre) {
                $scope.errores.nombre = '';
            }
        }

        function validaCampoFecha() {
            if ($scope.datosFormulario.fecha) {
                $scope.errores.fecha = '';
            }
        }

        function validaCampoHora() {
            if ($scope.datosFormulario.hora) {
                $scope.errores.hora = '';
            }
        }

        function validaCampoDescCorta() {
            if ($scope.datosFormulario.descripcion) {
                $scope.errores.descripcion = '';
            }
        }

        function registrarEvento() {
            $scope.showFormInfo = false;
            $scope.showFormSinInfo = false;
            $scope.showFormRegistrar = true;
        }

        function getEventos() {
            $http.get($scope.urlBase + 'admGetEventos')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.eventos = data.object;
                        } else {
                            $scope.showFormSinInfo = true;
                            $scope.showFormInfo = false;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la informacion');
            });
        }

        //        $scope.hora1 = {id: 1, hora: '00:00:00', descripcion: '00:00:00 AM'};
//        $scope.hora2 = {id: 2, hora: '1:00:00', descripcion: '1:00:00 AM'};
//        $scope.hora3 = {id: 3, hora: '2:00:00', descripcion: '2:00:00 AM'};
//        $scope.hora4 = {id: 4, hora: '3:00:00', descripcion: '3:00:00 AM'};
//        $scope.hora5 = {id: 5, hora: '4:00:00', descripcion: '4:00:00 AM'};
//        $scope.hora6 = {id: 6, hora: '5:00:00', descripcion: '5:00:00 AM'};
//        $scope.hora7 = {id: 7, hora: '6:00:00', descripcion: '6:00:00 AM'};
//        $scope.hora8 = {id: 8, hora: '7:00:00', descripcion: '7:00:00 AM'};
//        $scope.hora9 = {id: 9, hora: '8:00:00', descripcion: '8:00:00 AM'};
//        $scope.hora10 = {id: 10, hora: '9:00:00', descripcion: '9:00:00 AM'};
//        $scope.hora11 = {id: 11, hora: '10:00:00', descripcion: '10:00:00 AM'};
//        $scope.hora12 = {id: 12, hora: '11:00:00', descripcion: '11:00:00 AM'};
        $scope.hora13 = {id: 13, hora: '12:00:00', descripcion: '12:00:00 MD'};
        $scope.hora14 = {id: 14, hora: '13:00:00', descripcion: '13:00:00 PM'};
        $scope.hora15 = {id: 15, hora: '14:00:00', descripcion: '14:00:00 PM'};
        $scope.hora16 = {id: 16, hora: '15:00:00', descripcion: '15:00:00 PM'};
        $scope.hora17 = {id: 17, hora: '16:00:00', descripcion: '16:00:00 PM'};
        $scope.hora18 = {id: 18, hora: '17:00:00', descripcion: '17:00:00 PM'};
        $scope.hora19 = {id: 19, hora: '18:00:00', descripcion: '18:00:00 PM'};
        $scope.hora20 = {id: 20, hora: '19:00:00', descripcion: '19:00:00 PM'};
        $scope.hora21 = {id: 21, hora: '20:00:00', descripcion: '20:00:00 PM'};
        $scope.hora22 = {id: 22, hora: '21:00:00', descripcion: '21:00:00 PM'};
//        $scope.hora23 = {id: 23, hora: '22:00:00', descripcion: '22:00:00 PM'};
//        $scope.hora24 = {id: 24, hora: '23:00:00', descripcion: '23:00:00 PM'};


//        $scope.selectHora.push($scope.hora1);
//        $scope.selectHora.push($scope.hora2);
//        $scope.selectHora.push($scope.hora3);
//        $scope.selectHora.push($scope.hora4);
//        $scope.selectHora.push($scope.hora5);
//        $scope.selectHora.push($scope.hora6);
//        $scope.selectHora.push($scope.hora7);
//        $scope.selectHora.push($scope.hora8);
//        $scope.selectHora.push($scope.hora9);
//        $scope.selectHora.push($scope.hora10);
//        $scope.selectHora.push($scope.hora11);
//        $scope.selectHora.push($scope.hora12);
        $scope.selectHora.push($scope.hora13);
        $scope.selectHora.push($scope.hora14);
        $scope.selectHora.push($scope.hora15);
        $scope.selectHora.push($scope.hora16);
        $scope.selectHora.push($scope.hora17);
        $scope.selectHora.push($scope.hora18);
        $scope.selectHora.push($scope.hora19);
        $scope.selectHora.push($scope.hora20);
        $scope.selectHora.push($scope.hora21);
        $scope.selectHora.push($scope.hora22);
//        $scope.selectHora.push($scope.hora23);
//        $scope.selectHora.push($scope.hora24);

        getEventos();

    }

})();