(function () {
    'use strict';

    angular.module('AdminPorto.controllers').controller('CotizarCtrl', CotizarCtrl);

    CotizarCtrl.$inject = ['$scope', '$http'];

    function CotizarCtrl($scope, $http) {
        console.log('<<<<controler CotizarCtrl>>>');

//        $scope.urlBase = 'http://localhost:8050/adminPortoAlto/Administrativo/servicios/v1/';
        $scope.urlBase = 'http://www.portoalto.com.co/Administrativo/Administrativo/servicios/v1/';

        $scope.pageSize = 6;
        $scope.currentPage = 1;
        $scope.selectHora = [];
        $scope.datosFormulario = {};
        $scope.errores = {};
        $scope.regExpEmail = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.([a-zA-Z]{2,4})+$/;
        $scope.regExpNumero = /^[0-9]*$/;
        $scope.showFormReg = false;

        $scope.registrar = registrar;
        $scope.validaCampoNombre = validaCampoNombre;
        $scope.validaCampoEmpresa = validaCampoEmpresa;
        $scope.validaCampoTelefono = validaCampoTelefono;
        $scope.validaCampoCelular = validaCampoCelular;
        $scope.validaCampoCiudad = validaCampoCiudad;
        $scope.validaCampoEmail = validaCampoEmail;
        $scope.validaCampoLocalidad = validaCampoLocalidad;
        $scope.validaCampoFecha = validaCampoFecha;
        $scope.validaCampoEvento = validaCampoEvento;
        $scope.validaCampoHoraEvento = validaCampoHoraEvento;
        $scope.validaCampoHoraIngreso = validaCampoHoraIngreso;
        $scope.validaCampoHoraSalida = validaCampoHoraSalida;
        $scope.validaCampoNumPersonas = validaCampoNumPersonas;
        $scope.validaCampoNumMenorEdad = validaCampoNumMenorEdad;
        $scope.validaCampoPresupuesto = validaCampoPresupuesto;
        $scope.validaCampoDetalle = validaCampoDetalle;
        $scope.validaCampoTotal = validaCampoTotal;
        $scope.confirmarCotizacion = confirmarCotizacion;
        $scope.sentMail = sentMail;
        $scope.botonRegEvento = botonRegEvento;
        $scope.cancelar = cancelar;
        $scope.cotizaciones = cotizaciones;
        $scope.verDetalle = verDetalle;

        function verDetalle(item) {
            $scope.itemSelect = item;
            $('#dlgVerDetalle').modal({backdrop: 'static', keyboard: false});
        }

        function cotizaciones() {
            $http.get($scope.urlBase + 'admGetCotizacion')
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.resultadoCotizacion = data.object;
                        } else {
                            $scope.showFormSinInfo = true;
                            $scope.showFormInfo = false;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        cotizaciones();

        function cancelar() {
            $scope.datosFormulario = {};
            $scope.errores = {};
            $scope.showFormReg = false;
        }

        function botonRegEvento() {
            $scope.showFormReg = true;
        }

        function sentMail() {
            $scope.datosMail = {};
            $scope.datosMail.nombre = $scope.datosFormulario.nombre;
            $scope.datosMail.email = $scope.datosFormulario.email;
            $scope.datosMail.mensaje = "Se registró de forma exitosa la cotización, a continuación un resumen de su pedido : \n\
                                        Nombre de la empresa : " + $scope.datosFormulario.nombre + "\n\
                                        Ciudad : " + $scope.datosFormulario.ciudad + "\n\
                                        Localidad : " + $scope.datosFormulario.localidad + "\n\
                                        Fecha del evento : " + $scope.datosFormulario.fecha + "\n\
                                        Hora de ingreso : " + $scope.datosFormulario.horaIngreso.descripcion + "\n\
                                        Hora de salida : " + $scope.datosFormulario.horaSalida.descripcion + "\n\
                                        Número de personas : " + $scope.datosFormulario.numeroPersonas + "\n\
                                        Detalle del evento : " + $scope.datosFormulario.detalle + "\n\
                                        Total : " + $scope.datosFormulario.total;
            $http.post($scope.urlBase + 'admSentMail', $scope.datosMail)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            $scope.datosFormulario = {};
                            $scope.datos = {};
                            $('#dlgConfContizacion').modal('hide');
                            $('#dlgSucces').modal({backdrop: 'static', keyboard: false});
                            cotizaciones();
                            $scope.showFormReg = false;
                        } else {
                            $('#dlgError').modal({backdrop: 'static', keyboard: false});
                            $scope.message = data.message;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function confirmarCotizacion() {
            $scope.datos = {};
            $scope.datos.cliente = $scope.datosFormulario.nombre;
            $scope.datos.empresa = $scope.datosFormulario.empresa;
            $scope.datos.telefono = $scope.datosFormulario.telefono;
            $scope.datos.celular = $scope.datosFormulario.celular;
            $scope.datos.ciudad = $scope.datosFormulario.ciudad;
            $scope.datos.email = $scope.datosFormulario.email;
            $scope.datos.locacion = $scope.datosFormulario.localidad;
            $scope.datos.fecha = $scope.datosFormulario.fecha;
            $scope.datos.evento = $scope.datosFormulario.evento;
            $scope.datos.horass = $scope.datosFormulario.horaEvento;
            $scope.datos.horai = $scope.datosFormulario.horaIngreso.descripcion;
            $scope.datos.horas = $scope.datosFormulario.horaSalida.descripcion;
            $scope.datos.personas = $scope.datosFormulario.numeroPersonas;
            $scope.datos.menores = $scope.datosFormulario.menorEdad;
            $scope.datos.presupuesto = $scope.datosFormulario.presupuesto;
            $scope.datos.detalle = $scope.datosFormulario.detalle;
            $scope.datos.total = $scope.datosFormulario.total;
            $http.post($scope.urlBase + 'admCotizar', $scope.datos)
                    .success(function (data, status, header, config) {
                        if (data.status === 'SUCCESS') {
                            sentMail();
                        } else {
                            $('#dlgError').modal({backdrop: 'static', keyboard: false});
                            $scope.message = data.message;
                        }
                    }).error(function (data, status, header, config) {
                alert('Error al consultar la información');
            });
        }

        function registrar() {
            var error = false;
            if (!$scope.datosFormulario.nombre) {
                $scope.errores.nombre = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.empresa) {
                $scope.errores.empresa = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.telefono) {
                $scope.errores.telefono = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.telefono)) {
                    $scope.errores.telefono = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.celular) {
                $scope.errores.celular = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.celular)) {
                    $scope.errores.celular = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.ciudad) {
                $scope.errores.ciudad = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.email) {
                $scope.errores.email = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpEmail.test($scope.datosFormulario.email)) {
                    $scope.errores.email = 'El campo no cumple con el formato de un email valido';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.localidad) {
                $scope.errores.localidad = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.fecha) {
                $scope.errores.fecha = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.evento) {
                $scope.errores.evento = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.horaEvento) {
                $scope.errores.horaEvento = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.horaEvento)) {
                    $scope.errores.horaEvento = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.horaIngreso) {
                $scope.errores.horaIngreso = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.horaSalida) {
                $scope.errores.horaSalida = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.numeroPersonas) {
                $scope.errores.numeroPersonas = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.numeroPersonas)) {
                    $scope.errores.numeroPersonas = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.menorEdad) {
                $scope.errores.menorEdad = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.menorEdad)) {
                    $scope.errores.menorEdad = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.presupuesto) {
                $scope.errores.presupuesto = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.presupuesto)) {
                    $scope.errores.presupuesto = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!$scope.datosFormulario.detalle) {
                $scope.errores.detalle = 'El campo es obligatorio';
                error = true;
            }
            if (!$scope.datosFormulario.total) {
                $scope.errores.total = 'El campo es obligatorio';
                error = true;
            } else {
                if (!$scope.regExpNumero.test($scope.datosFormulario.total)) {
                    $scope.errores.total = 'El campo debe ser numérico';
                    error = true;
                }
            }
            if (!error) {
                $('#dlgConfContizacion').modal({backdrop: 'static', keyboard: false});
            }
        }

        function validaCampoNombre() {
            if ($scope.datosFormulario.nombre) {
                $scope.errores.nombre = '';
            }
        }

        function validaCampoEmpresa() {
            if ($scope.datosFormulario.empresa) {
                $scope.errores.empresa = '';
            }
        }

        function validaCampoTelefono() {
            if ($scope.datosFormulario.telefono) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.telefono)) {
                    $scope.errores.telefono = 'El campo debe ser numérico';
                } else {
                    $scope.errores.telefono = '';
                }
            }
        }

        function validaCampoCelular() {
            if ($scope.datosFormulario.celular) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.celular)) {
                    $scope.errores.celular = 'El campo debe ser numérico';
                } else {
                    $scope.errores.celular = '';
                }
            }
        }

        function validaCampoCiudad() {
            if ($scope.datosFormulario.ciudad) {
                $scope.errores.ciudad = '';
            }
        }

        function validaCampoEmail() {
            if ($scope.datosFormulario.email) {
                if ($scope.regExpEmail.test($scope.datosFormulario.email)) {
                    $scope.errores.email = '';
                } else {
                    $scope.errores.email = 'El email ingresado no cumple con el formato adecuado.';
                }
            }
        }

        function validaCampoLocalidad() {
            if ($scope.datosFormulario.localidad) {
                $scope.errores.localidad = '';
            }
        }

        function validaCampoFecha() {
            if ($scope.datosFormulario.fecha) {
                $scope.errores.fecha = '';
            }
        }

        function validaCampoEvento() {
            if ($scope.datosFormulario.evento) {
                $scope.errores.evento = '';
            }
        }

        function validaCampoHoraEvento() {
            if ($scope.datosFormulario.horaEvento) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.horaEvento)) {
                    $scope.errores.horaEvento = 'El campo debe ser numérico';
                } else {
                    $scope.errores.horaEvento = '';
                }
            }
        }

        function validaCampoHoraIngreso() {
            if ($scope.datosFormulario.horaIngreso) {
                $scope.errores.horaIngreso = '';
            }
        }

        function validaCampoHoraSalida() {
            if ($scope.datosFormulario.horaSalida) {
                $scope.errores.horaSalida = '';
            }
        }

        function validaCampoNumPersonas() {
            if ($scope.datosFormulario.numeroPersonas) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.numeroPersonas)) {
                    $scope.errores.numeroPersonas = 'El campo debe ser numérico';
                } else {
                    $scope.errores.numeroPersonas = '';
                }
            }
        }

        function validaCampoNumMenorEdad() {
            if ($scope.datosFormulario.menorEdad) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.menorEdad)) {
                    $scope.errores.menorEdad = 'El campo debe ser numérico';
                } else {
                    $scope.errores.menorEdad = '';
                }
            }
        }

        function validaCampoPresupuesto() {
            if ($scope.datosFormulario.presupuesto) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.presupuesto)) {
                    $scope.errores.presupuesto = 'El campo debe ser numérico';
                } else {
                    $scope.errores.presupuesto = '';
                }
            }
        }

        function validaCampoDetalle() {
            if ($scope.datosFormulario.detalle) {
                $scope.errores.detalle = '';
            }
        }

        function validaCampoTotal() {
            if ($scope.datosFormulario.total) {
                if (!$scope.regExpNumero.test($scope.datosFormulario.total)) {
                    $scope.errores.total = 'El campo debe ser numérico';
                } else {
                    $scope.errores.total = '';
                }
            }
        }

        $scope.hora13 = {id: 13, hora: '12:00:00', descripcion: '12:00:00 MD'};
        $scope.hora14 = {id: 14, hora: '13:00:00', descripcion: '13:00:00 PM'};
        $scope.hora15 = {id: 15, hora: '14:00:00', descripcion: '14:00:00 PM'};
        $scope.hora16 = {id: 16, hora: '15:00:00', descripcion: '15:00:00 PM'};
        $scope.hora17 = {id: 17, hora: '16:00:00', descripcion: '16:00:00 PM'};
        $scope.hora18 = {id: 18, hora: '17:00:00', descripcion: '17:00:00 PM'};
        $scope.hora19 = {id: 19, hora: '18:00:00', descripcion: '18:00:00 PM'};
        $scope.hora20 = {id: 20, hora: '19:00:00', descripcion: '19:00:00 PM'};
        $scope.hora21 = {id: 21, hora: '20:00:00', descripcion: '20:00:00 PM'};
        $scope.hora22 = {id: 22, hora: '21:00:00', descripcion: '21:00:00 PM'};

        $scope.selectHora.push($scope.hora13);
        $scope.selectHora.push($scope.hora14);
        $scope.selectHora.push($scope.hora15);
        $scope.selectHora.push($scope.hora16);
        $scope.selectHora.push($scope.hora17);
        $scope.selectHora.push($scope.hora18);
        $scope.selectHora.push($scope.hora19);
        $scope.selectHora.push($scope.hora20);
        $scope.selectHora.push($scope.hora21);
        $scope.selectHora.push($scope.hora22);

    }

})();