'use strict';

/* Controllers */
var module = angular.module('AdminPorto.controllers', []);

var aceptoDeclaracion = false;
var mail = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,4})+$/;
var pass = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,10}$/;
var alfanumericoEspacio = /^[0-9a-záéíóúñA-ZÑÁÉÍÓÚüÜ\s]+$/;
var unNumero = /^(\d{1})$/;
var numero = /^[0-9]{0,15}$/;

var infoPlataforma = "La plataforma no esta disponible, consulte con el administrador";
var infoNoAcceso = "Usted no esta autorizado para ingresar a esta funcionalidad";
var msjForm = "Debe ingresar la información en todos los campos marcados como obligatorios (*)";
var dataUser;

/**
 * Controladores app demo CampoLimpio
 * @author ccepeda
 * @company MonkeySoft
 */
function baseController($scope) {
    /*$.getJSON('./webresources/parametrosServices/infoUser", function (data) {
     console.log(data);
     });*/

    $scope.msjExito = function (mensaje) {
        new PNotify({
            title: "Transacción exitosa",
            text: mensaje,
            type: 'success'
        });
    };
    $scope.msjError = function (mensaje) {
        new PNotify({
            title: "Oh No!",
            text: mensaje,
            type: 'error'
        });
    };
    $scope.msjInfo = function (mensaje) {
        new PNotify({
            title: "Información",
            text: mensaje,
            type: 'info'
        });
    };

    $scope.validaWs = function (status) {
        if (status === 401) {
            window.location.href = './login.html#/login';
        }
    };
}
module.controller('InfoUserCtrl', ['$scope', '$http', function ($scope, $http) {
        $scope.dataUser = {};
        $scope.infoUser = {};
        $scope.listMenu = [];
        baseController($scope);
    }]);

module.controller('HomeCtrl', ['$scope', '$http', function ($scope, $http) {
        console.log("Controlador home cargado!!!!");

        baseController($scope);
        $scope.fecha

        //baseController($scope);
        $scope.cancel = function () {
            window.location.href = './login.html#/login';
        };

        $scope.cerrarSesion = function () {
            $http.get('./webresources/autenticateServices/logout', {}
            ).success(function (data, status, headers, config) {
                $scope.msjExito("Sesión terminada exitosamente. <br> Vuelva pronto!!.");
                window.location.href = './login.html';
            }).error(function (data, status, headers, config) {
                $scope.msjInfo(infoPlataforma);
                $scope.validaWs(status);
            });
        };
    }]);




module.controller('SolJuducialCtrl', ['$scope', '$http', function ($scope, $http) {
        console.log("Controlador AnticiposCtrl cargado!!!!");

        $scope.listMunicpio = [];
        $scope.listJuzgados = [];
        $scope.deptoSelect = null;
        $scope.juzgadoSelected = null;

        $scope.solicitud = {};
        $scope.form1 = true;
        $scope.form2 = false;
        $scope.viewTab2 = false;

        $scope.frmEnviado = false;
        $scope.errores = {};

        $scope.changetab = function (index) {
            if (index === 1) {
                $scope.form1 = true;
                $scope.form2 = false;

            } else if (index === 2) {
                $scope.form2 = true;
                $scope.form1 = false;
            }
        };
        
        $scope.pago = false;

        $scope.chageDepto = function () {
            console.log('Depto selected : ' + $scope.deptoSelect);
            if ($scope.deptoSelect) {
                if ($scope.deptoSelect === '1') {
                    $scope.listMunicpio = [{id: 1, name: "Bogotá DC"}];
                } else {
                    $scope.listMunicpio = [{id: 2, name: "Agua De Dios"}, {id: 3, name: "Anapoima"}, {id: 4, name: "Anolaima"}, {id: 5, name: "Otro"}];
                }
            } else {
                alert('Debe seleccionar un departamento');
            }
        };


        $scope.changeMuncpio = function () {
            console.log('Seleccionando municipio...' + JSON.stringify($scope.solicitud.mcpio));
            if ($scope.solicitud.mcpio) {
                if ($scope.solicitud.mcpio === '1') {
                    $scope.info1 = {"id": "1", "name": "001 C.SU SALA CASACION CIVIL B", "oficina": "BOGOTA - DEPOSITOS JUDICIALES (CENTRO)", "dir": "Calle 14 No.7-33 Local 101", "codigo": "110010203001"};
                    $scope.info2 = {"id": "2", "name": "001 C.SU SALA CASACION PENAL B", "oficina": "BOGOTA - DEPOSITOS JUDICIALES (CENTRO)", "dir": "Calle 14 No.7-33 Local 101", "codigo": "110010204001"};
                    $scope.info3 = {"id": "3", "name": "001 C.SU SALA CASACION LABORA", "oficina": "BOGOTA - DEPOSITOS JUDICIALES (CENTRO)", "dir": "Calle 14 No.7-33 Local 101", "codigo": "110010205001"};
                    $scope.info4 = {"id": "4", "name": "001 C.E. SECRE GENERAL BOGOTA", "oficina": "BOGOTA - DEPOSITOS JUDICIALES (CENTRO)", "dir": "Calle 14 No.7-33 Local 101", "codigo": "110010315001"};

                    $scope.listJuzgados = [];
                    $scope.listJuzgados.push($scope.info1);
                    $scope.listJuzgados.push($scope.info2);
                    $scope.listJuzgados.push($scope.info3);
                    $scope.listJuzgados.push($scope.info4);
                } else if ($scope.solicitud.mcpio === '2') {
                    $scope.listJuzgados = [
                        {"id": 1, "name": "001 PROMISCUO MUNICIPAL AGUA D", "oficina": "AGUA DE DIOS", "dir": "Carrera 9 No.14-02/08", "codigo": "250014089001"}
                    ];
                } else if ($scope.solicitud.mcpio === '3') {
                    $scope.listJuzgados = [
                        {"id": 1, "name": "001 PROMISCUO MUNICIPAL ANAPOI", "oficina": "ANAPOIMA", "dir": "Carrera 9 No.14-02/08", "codigo": "258154089001"},
                        {"id": 2, "name": "JUZ.PROMISCUO MUNICIPAL TOCAIM", "oficina": "ANAPOIMA", "dir": "Carrera 9 No.14-02/08", "codigo": "258156075001"}
                    ];
                }

            } else {
                alert('Debe seleccionar un municipio');
            }
        };

        $scope.infoJuzgado = {};
        $scope.loadJuzgado = function () {
            $scope.infoJuzgado = JSON.parse($scope.juzgadoSelected);
            console.log($scope.infoJuzgado);
        };

        $scope.continuarSolicitud = function (form) {
            console.log(">> Enviando");
            if (form.$valid) {
                $scope.viewTab2 = true;
                $scope.frmEnviado = false;
                $scope.changetab(2);
                console.log("ok");
            } else {
                console.log('formulario novalido');
                $scope.frmEnviado = true;
            }
        };
        $scope.continuarSolicitudFin = function (form) {
            console.log(">> Enviando");
            if (form.$valid) {
                $scope.viewTab2 = true;
                $scope.frmEnviado = false;
                $scope.changetab(2);
                console.log("ok");
                $scope.pago = true;
            } else {
                console.log('formulario novalido');
                $scope.frmEnviado = true;
            }
        };
        
        $scope.pagarPSE = function(){
            alert("FUNCION NO DISPONIBLE PARA ESTA DEMO");
        };
         $scope.pagarBANCO = function(){
            alert("FUNCION NO DISPONIBLE PARA ESTA DEMO");
        };


    }]);


